/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.playertracer.libs.obsidian.lib.libby.transitive;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import me.devadri.playertracer.libs.obsidian.lib.libby.Library;
import me.devadri.playertracer.libs.obsidian.lib.libby.LibraryManager;
import me.devadri.playertracer.libs.obsidian.lib.libby.Util;
import me.devadri.playertracer.libs.obsidian.lib.libby.classloader.IsolatedClassLoader;
import me.devadri.playertracer.libs.obsidian.lib.libby.transitive.ExcludedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransitiveDependencyHelper {
    private static final String TRANSITIVE_DEPENDENCY_COLLECTOR_CLASS = Util.replaceWithDots("com{}alessiodp{}libby{}maven{}resolver{}TransitiveDependencyCollector");
    private static final String ARTIFACT_CLASS = Util.replaceWithDots("org{}eclipse{}aether{}artifact{}Artifact");
    private final Object transitiveDependencyCollectorObject;
    private final Method resolveTransitiveDependenciesMethod;
    private final Method artifactGetGroupIdMethod;
    private final Method artifactGetArtifactIdMethod;
    private final Method artifactGetVersionMethod;
    private final Method artifactGetBaseVersionMethod;
    private final Method artifactGetClassifierMethod;
    private final LibraryManager libraryManager;

    public TransitiveDependencyHelper(@NotNull LibraryManager libraryManager, @NotNull Path saveDirectory) {
        Objects.requireNonNull(libraryManager, "libraryManager");
        this.libraryManager = libraryManager;
        IsolatedClassLoader classLoader = new IsolatedClassLoader(new URL[0]);
        classLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("com{}alessiodp{}libby{}maven{}resolver").artifactId("libby-maven-resolver").version("1.0.1").checksumFromBase64("EmsSUwjtqSeYTt8WEw7LPI/5Yz8bWSxf23XcdLEM7dk=").repository("https://repo1.maven.org/maven2/").repository("https://repo.alessiodp.com/releases").build()));
        try {
            Class<?> transitiveDependencyCollectorClass = classLoader.loadClass(TRANSITIVE_DEPENDENCY_COLLECTOR_CLASS);
            Class<?> artifactClass = classLoader.loadClass(ARTIFACT_CLASS);
            Constructor<?> constructor = transitiveDependencyCollectorClass.getConstructor(Path.class);
            constructor.setAccessible(true);
            this.transitiveDependencyCollectorObject = constructor.newInstance(saveDirectory);
            this.resolveTransitiveDependenciesMethod = transitiveDependencyCollectorClass.getMethod("findTransitiveDependencies", String.class, String.class, String.class, String.class, Stream.class);
            this.resolveTransitiveDependenciesMethod.setAccessible(true);
            this.artifactGetGroupIdMethod = artifactClass.getMethod("getGroupId", new Class[0]);
            this.artifactGetArtifactIdMethod = artifactClass.getMethod("getArtifactId", new Class[0]);
            this.artifactGetVersionMethod = artifactClass.getMethod("getVersion", new Class[0]);
            this.artifactGetBaseVersionMethod = artifactClass.getMethod("getBaseVersion", new Class[0]);
            this.artifactGetClassifierMethod = artifactClass.getMethod("getClassifier", new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Collection<Library> findTransitiveLibraries(@NotNull Library library) {
        ArrayList<Library> transitiveLibraries = new ArrayList<Library>();
        HashSet<ExcludedDependency> excludedDependencies = new HashSet<ExcludedDependency>(library.getExcludedTransitiveDependencies());
        Collection<String> globalRepositories = this.libraryManager.getRepositories();
        Collection<String> libraryRepositories = library.getRepositories();
        if (globalRepositories.isEmpty() && libraryRepositories.isEmpty()) {
            throw new IllegalArgumentException("No repositories have been added before resolving transitive dependencies");
        }
        Stream repositories = Stream.of(globalRepositories, libraryRepositories).flatMap(Collection::stream);
        try {
            Collection resolvedArtifacts = (Collection)this.resolveTransitiveDependenciesMethod.invoke(this.transitiveDependencyCollectorObject, library.getGroupId(), library.getArtifactId(), library.getVersion(), library.getClassifier(), repositories);
            for (Object resolved : resolvedArtifacts) {
                Map.Entry resolvedEntry = (Map.Entry)resolved;
                Object artifact = resolvedEntry.getKey();
                @Nullable String repository = (String)resolvedEntry.getValue();
                String groupId = (String)this.artifactGetGroupIdMethod.invoke(artifact, new Object[0]);
                String artifactId = (String)this.artifactGetArtifactIdMethod.invoke(artifact, new Object[0]);
                String baseVersion = (String)this.artifactGetBaseVersionMethod.invoke(artifact, new Object[0]);
                String classifier = (String)this.artifactGetClassifierMethod.invoke(artifact, new Object[0]);
                if (library.getGroupId().equals(groupId) && library.getArtifactId().equals(artifactId) || excludedDependencies.contains(new ExcludedDependency(groupId, artifactId))) continue;
                Library.Builder libraryBuilder = Library.builder().groupId(groupId).artifactId(artifactId).version(baseVersion).isolatedLoad(library.isIsolatedLoad()).loaderId(library.getLoaderId());
                if (classifier != null && !classifier.isEmpty()) {
                    libraryBuilder.classifier(classifier);
                }
                library.getRelocations().forEach(libraryBuilder::relocate);
                if (repository != null) {
                    if (!repository.endsWith("/")) {
                        repository = repository + '/';
                    }
                    String version = (String)this.artifactGetVersionMethod.invoke(artifact, new Object[0]);
                    String partialPath = Util.craftPartialPath(artifactId, groupId, baseVersion);
                    String path = Util.craftPath(partialPath, artifactId, version, classifier);
                    libraryBuilder.url(repository + path);
                } else {
                    library.getRepositories().forEach(libraryBuilder::repository);
                }
                transitiveLibraries.add(libraryBuilder.build());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableCollection(transitiveLibraries);
    }
}

