/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.playertracer.libs.obsidian.lib.libby.relocation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import me.devadri.playertracer.libs.obsidian.lib.libby.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relocation {
    @NotNull
    private final String pattern;
    @NotNull
    private final String relocatedPattern;
    @NotNull
    private final Collection<String> includes;
    @NotNull
    private final Collection<String> excludes;

    public Relocation(@NotNull String pattern, @NotNull String relocatedPattern, @Nullable Collection<String> includes, @Nullable Collection<String> excludes) {
        this.pattern = Util.replaceWithDots(Objects.requireNonNull(pattern, "pattern"));
        this.relocatedPattern = Util.replaceWithDots(Objects.requireNonNull(relocatedPattern, "relocatedPattern"));
        this.includes = includes != null ? Collections.unmodifiableSet(includes.stream().map(Util::replaceWithDots).collect(Collectors.toSet())) : Collections.emptySet();
        this.excludes = excludes != null ? Collections.unmodifiableSet(excludes.stream().map(Util::replaceWithDots).collect(Collectors.toSet())) : Collections.emptySet();
    }

    public Relocation(@NotNull String pattern, @NotNull String relocatedPattern) {
        this(pattern, relocatedPattern, null, null);
    }

    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    @NotNull
    public String getRelocatedPattern() {
        return this.relocatedPattern;
    }

    @NotNull
    public Collection<String> getIncludes() {
        return this.includes;
    }

    @NotNull
    public Collection<String> getExcludes() {
        return this.excludes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relocation that = (Relocation)o;
        if (!this.pattern.equals(that.pattern)) {
            return false;
        }
        if (!this.relocatedPattern.equals(that.relocatedPattern)) {
            return false;
        }
        if (!this.includes.equals(that.includes)) {
            return false;
        }
        return this.excludes.equals(that.excludes);
    }

    public int hashCode() {
        int result = this.pattern.hashCode();
        result = 31 * result + this.relocatedPattern.hashCode();
        result = 31 * result + this.includes.hashCode();
        result = 31 * result + this.excludes.hashCode();
        return result;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pattern;
        private String relocatedPattern;
        private final Collection<String> includes = new LinkedList<String>();
        private final Collection<String> excludes = new LinkedList<String>();

        @NotNull
        public Builder pattern(@NotNull String pattern) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            return this;
        }

        @NotNull
        public Builder relocatedPattern(@NotNull String relocatedPattern) {
            this.relocatedPattern = Objects.requireNonNull(relocatedPattern, "relocatedPattern");
            return this;
        }

        @NotNull
        public Builder include(@NotNull String include) {
            this.includes.add(Objects.requireNonNull(include, "include"));
            return this;
        }

        @NotNull
        public Builder exclude(@NotNull String exclude) {
            this.excludes.add(Objects.requireNonNull(exclude, "exclude"));
            return this;
        }

        @NotNull
        public Relocation build() {
            return new Relocation(this.pattern, this.relocatedPattern, this.includes, this.excludes);
        }
    }
}

