/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.playertracer.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import me.devadri.playertracer.PlayerTracerPlugin;
import me.devadri.playertracer.api.logs.Log;
import me.devadri.playertracer.database.tables.LogsTable;
import me.devadri.playertracer.libs.obsidian.logger.Logger;
import me.devadri.playertracer.logs.LogsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H&J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J%\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lme/devadri/playertracer/database/LogsDatabase;", "", "<init>", "()V", "plugin", "Lme/devadri/playertracer/PlayerTracerPlugin;", "getPlugin", "()Lme/devadri/playertracer/PlayerTracerPlugin;", "logger", "Lme/devadri/playertracer/libs/obsidian/logger/Logger;", "database", "Lorg/jetbrains/exposed/sql/Database;", "getDatabase", "()Lorg/jetbrains/exposed/sql/Database;", "setDatabase", "(Lorg/jetbrains/exposed/sql/Database;)V", "initializeDatabase", "", "connect", "addLog", "log", "Lme/devadri/playertracer/api/logs/Log;", "getLogs", "", "uuids", "", "Ljava/util/UUID;", "([Ljava/util/UUID;)Ljava/util/List;", "getLogsAsync", "([Ljava/util/UUID;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "PlayerTracer"})
@SourceDebugExtension(value={"SMAP\nLogsDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogsDatabase.kt\nme/devadri/playertracer/database/LogsDatabase\n+ 2 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n296#2,4:93\n11228#3:97\n11563#3,3:98\n1617#4,9:101\n1869#4:110\n1870#4:112\n1626#4:113\n1#5:111\n*S KotlinDebug\n*F\n+ 1 LogsDatabase.kt\nme/devadri/playertracer/database/LogsDatabase\n*L\n53#1:93,4\n70#1:97\n70#1:98,3\n71#1:101,9\n71#1:110\n71#1:112\n71#1:113\n71#1:111\n*E\n"})
public abstract class LogsDatabase {
    @NotNull
    private final PlayerTracerPlugin plugin = PlayerTracerPlugin.Companion.getInstance();
    @NotNull
    private final Logger logger;
    public Database database;

    public LogsDatabase() {
        this.logger = this.plugin.logger;
        this.initializeDatabase();
        this.connect();
    }

    @NotNull
    protected final PlayerTracerPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final Database getDatabase() {
        Database database = this.database;
        if (database != null) {
            return database;
        }
        Intrinsics.throwUninitializedPropertyAccessException("database");
        return null;
    }

    public final void setDatabase(@NotNull Database database) {
        Intrinsics.checkNotNullParameter(database, "<set-?>");
        this.database = database;
    }

    public abstract void initializeDatabase();

    public final void connect() {
        try {
            ThreadLocalTransactionManagerKt.transaction((Database)this.getDatabase(), LogsDatabase::connect$lambda$0);
            this.logger.info("Connected to the database successfully.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to the database", e);
        }
    }

    public final void addLog(@NotNull Log log) {
        Intrinsics.checkNotNullParameter(log, "log");
        ThreadLocalTransactionManagerKt.transaction((Database)this.getDatabase(), arg_0 -> LogsDatabase.addLog$lambda$2(log, this, arg_0));
    }

    @NotNull
    public final List<Log> getLogs(UUID ... uuids) {
        Intrinsics.checkNotNullParameter(uuids, "uuids");
        return (List)ThreadLocalTransactionManagerKt.transaction((Database)this.getDatabase(), arg_0 -> LogsDatabase.getLogs$lambda$5(uuids, this, arg_0));
    }

    @Nullable
    public final Object getLogsAsync(@NotNull UUID[] uuids, @NotNull Continuation<? super List<? extends Log>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Log>>, Object>(this, uuids, null){
            int label;
            final /* synthetic */ LogsDatabase this$0;
            final /* synthetic */ UUID[] $uuids;
            {
                this.this$0 = $receiver;
                this.$uuids = $uuids;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        return this.this$0.getLogs(Arrays.copyOf(this.$uuids, this.$uuids.length));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends Log>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private static final Unit connect$lambda$0(Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
        LogsTable[] logsTableArray = new LogsTable[]{LogsTable.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])logsTableArray, (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final InsertStatement addLog$lambda$2(Log $log, LogsDatabase this$0, Transaction $this$transaction) {
        void it;
        InsertStatement insertStatement;
        Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
        Table $this$insert$iv = LogsTable.INSTANCE;
        boolean $i$f$insert = false;
        InsertStatement $this$insert_u24lambda_u243$iv = insertStatement = new InsertStatement($this$insert$iv, false, 2, null);
        boolean bl = false;
        InsertStatement insertStatement2 = $this$insert_u24lambda_u243$iv;
        LogsTable $this$addLog_u24lambda_u242_u24lambda_u241 = (LogsTable)$this$insert$iv;
        boolean bl2 = false;
        it.set($this$addLog_u24lambda_u242_u24lambda_u241.getPlayerUUID(), (Object)$log.getPlayerUUID().toString());
        Column<String> column = $this$addLog_u24lambda_u242_u24lambda_u241.getClass();
        String string = Reflection.getOrCreateKotlinClass($log.getClass()).getQualifiedName();
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type kotlin.String");
        it.set(column, (Object)string);
        it.set($this$addLog_u24lambda_u242_u24lambda_u241.getData(), (Object)this$0.getPlugin().getLogsProvider().encodeToJson($log));
        $this$insert_u24lambda_u243$iv.execute(TransactionManager.Companion.current());
        return insertStatement;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getLogs$lambda$5(UUID[] $uuids, LogsDatabase this$0, Transaction $this$transaction) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
        List logs = new ArrayList();
        Object[] objectArray = new Expression[]{LogsTable.INSTANCE.getClass(), LogsTable.INSTANCE.getData()};
        Query query = LogsTable.INSTANCE.select((Expression)LogsTable.INSTANCE.getId(), (Expression[])objectArray);
        objectArray = $uuids;
        ExpressionWithColumnType expressionWithColumnType = (ExpressionWithColumnType)LogsTable.INSTANCE.getPlayerUUID();
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        Expression expression = (Expression)OpKt.and((Expression)((Expression)SqlExpressionBuilder.INSTANCE.isNotNull((Expression)LogsTable.INSTANCE.getData())), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.isNotNull((Expression)LogsTable.INSTANCE.getClass())));
        Query query2 = query;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = (Iterable)query2.where(OpKt.and((Expression)expression, (Expression)((Expression)sqlExpressionBuilder.inList(expressionWithColumnType, (Iterable)collection))));
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ResultRow it = (ResultRow)element$iv$iv;
            boolean bl2 = false;
            Class<?> clazz = Class.forName((String)it.get((Expression)LogsTable.INSTANCE.getClass()));
            Intrinsics.checkNotNullExpressionValue(clazz, "forName(...)");
            KClass<?> kClass = JvmClassMappingKt.getKotlinClass(clazz);
            if (!KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(Log.class))) {
                throw new IllegalArgumentException("Class " + it.get((Expression)LogsTable.INSTANCE.getClass()) + " is not a subclass of Log");
            }
            LogsProvider logsProvider = this$0.plugin.getLogsProvider();
            String string = (String)it.get((Expression)LogsTable.INSTANCE.getData());
            Class<?> clazz2 = Class.forName((String)it.get((Expression)LogsTable.INSTANCE.getClass()));
            Intrinsics.checkNotNullExpressionValue(clazz2, "forName(...)");
            KClass<?> kClass2 = JvmClassMappingKt.getKotlinClass(clazz2);
            Intrinsics.checkNotNull(kClass2, "null cannot be cast to non-null type kotlin.reflect.KClass<out me.devadri.playertracer.api.logs.Log>");
            Boolean it$iv$iv = logs.add(logsProvider.decodeFromJson(string, kClass2));
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return CollectionsKt.reversed(logs);
    }
}

