/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.playertracer.api.logs;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.devadri.playertracer.api.logs.Log;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lme/devadri/playertracer/api/logs/AbstractLog;", "Lme/devadri/playertracer/api/logs/Log;", "message", "", "player", "Lorg/bukkit/entity/Player;", "timestamp", "", "<init>", "(Ljava/lang/String;Lorg/bukkit/entity/Player;J)V", "(Ljava/lang/String;Lorg/bukkit/entity/Player;)V", "getMessage", "()Ljava/lang/String;", "getTimestamp", "()J", "playerUUID", "Ljava/util/UUID;", "Lorg/jetbrains/annotations/NotNull;", "getPlayerUUID", "()Ljava/util/UUID;", "location", "Lme/devadri/playertracer/api/location/Location;", "getLocation", "()Lme/devadri/playertracer/api/location/Location;", "api"})
public abstract class AbstractLog
implements Log {
    @NotNull
    private final String message;
    private final long timestamp;
    @NotNull
    private final UUID playerUUID;
    @NotNull
    private final me.devadri.playertracer.api.location.Location location;

    public AbstractLog(@NotNull String message, @NotNull Player player, long timestamp) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(player, "player");
        this.message = message;
        this.timestamp = timestamp;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.playerUUID = uUID;
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.location = me.devadri.playertracer.api.location.Location.Companion.fromBukkitLocation(location);
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public AbstractLog(@NotNull String message, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(player, "player");
        this(message, player, Timestamp.from(Instant.now()).getTime());
    }

    @Override
    @NotNull
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Override
    @NotNull
    public me.devadri.playertracer.api.location.Location getLocation() {
        return this.location;
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return Log.DefaultImpls.getPlayer(this);
    }

    @Override
    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        return Log.DefaultImpls.getOfflinePlayer(this);
    }
}

