/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.playertracer.api.location;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0011"}, d2={"Lme/devadri/playertracer/api/location/Location;", "", "worldName", "", "x", "", "y", "z", "<init>", "(Ljava/lang/String;DDD)V", "getWorldName", "()Ljava/lang/String;", "getX", "()D", "getY", "getZ", "Companion", "api"})
public final class Location {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String worldName;
    private final double x;
    private final double y;
    private final double z;
    @JvmField
    @NotNull
    public static final PersistentDataType<String, Location> PERSISTENT_DATA_TYPE = (PersistentDataType)new PersistentDataType<String, Location>(){

        public Class<String> getPrimitiveType() {
            return String.class;
        }

        public Class<Location> getComplexType() {
            return Location.class;
        }

        public String toPrimitive(Location complex, PersistentDataAdapterContext context) {
            Intrinsics.checkNotNullParameter(complex, "complex");
            Intrinsics.checkNotNullParameter(context, "context");
            return complex.getWorldName() + ":" + complex.getX() + ":" + complex.getY() + ":" + complex.getZ();
        }

        public Location fromPrimitive(String primitive, PersistentDataAdapterContext context) {
            Intrinsics.checkNotNullParameter(primitive, "primitive");
            Intrinsics.checkNotNullParameter(context, "context");
            String[] stringArray = new String[]{":"};
            List l = StringsKt.split$default((CharSequence)primitive, stringArray, false, 0, 6, null);
            String worldName = (String)l.get(0);
            Double d = StringsKt.toDoubleOrNull((String)l.get(1));
            double x = d != null ? d : 0.0;
            Double d2 = StringsKt.toDoubleOrNull((String)l.get(2));
            double y = d2 != null ? d2 : 0.0;
            Double d3 = StringsKt.toDoubleOrNull((String)l.get(3));
            double z = d3 != null ? d3 : 0.0;
            return new Location(worldName, x, y, z);
        }
    };

    public Location(@NotNull String worldName, double x, double y, double z) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        this.worldName = worldName;
        this.x = Location.Companion.truncateDouble(x);
        this.y = Location.Companion.truncateDouble(y);
        this.z = Location.Companion.truncateDouble(z);
    }

    @NotNull
    public final String getWorldName() {
        return this.worldName;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    @JvmStatic
    @NotNull
    public static final Location fromBukkitLocation(@NotNull org.bukkit.Location location) {
        return Companion.fromBukkitLocation(location);
    }

    @JvmStatic
    private static final double truncateDouble(double d) {
        return Location.Companion.truncateDouble(d);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0003R\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00050\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/devadri/playertracer/api/location/Location$Companion;", "", "<init>", "()V", "fromBukkitLocation", "Lme/devadri/playertracer/api/location/Location;", "location", "Lorg/bukkit/Location;", "truncateDouble", "", "double", "PERSISTENT_DATA_TYPE", "Lorg/bukkit/persistence/PersistentDataType;", "", "api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Location fromBukkitLocation(@NotNull org.bukkit.Location location) {
            Intrinsics.checkNotNullParameter(location, "location");
            Object object = location.getWorld();
            if (object == null || (object = object.getName()) == null) {
                object = "world";
            }
            return new Location((String)object, location.getX(), location.getY(), location.getZ());
        }

        @JvmStatic
        private final double truncateDouble(double d) {
            double factor = Math.pow(10.0, 2);
            return Math.floor(d * factor) / factor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

