/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.obsidian.serializer.boostedyaml;

import com.cryptomorin.xseries.XSound;
import dev.dejvokep.boostedyaml.serialization.standard.TypeAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.devadri.obsidian.sound.Sound;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016J \u0010\t\u001a\u00020\u00022\u0016\u0010\n\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lme/devadri/obsidian/serializer/boostedyaml/SoundSerializer;", "Ldev/dejvokep/boostedyaml/serialization/standard/TypeAdapter;", "Lme/devadri/obsidian/sound/Sound;", "<init>", "()V", "serialize", "", "", "sound", "deserialize", "map", "core"})
public final class SoundSerializer
implements TypeAdapter<Sound> {
    @NotNull
    public Map<? super Object, Object> serialize(@NotNull Sound sound) {
        Intrinsics.checkNotNullParameter(sound, "sound");
        Map map = new LinkedHashMap();
        map.put("sound", sound.getSound().name());
        if (!(sound.getVolume() == 1.0f)) {
            map.put("volume", Float.valueOf(sound.getVolume()));
        }
        if (!(sound.getPitch() == 1.0f)) {
            map.put("pitch", Float.valueOf(sound.getPitch()));
        }
        map.put("category", sound.getCategory().name());
        return map;
    }

    @NotNull
    public Sound deserialize(@NotNull Map<? super Object, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        Object object = map.get("sound");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        Optional sound = XSound.of((String)((String)object));
        if (sound.isEmpty()) {
            throw new IllegalArgumentException("Sound " + map.get("sound") + " is not valid");
        }
        float volume = 1.0f;
        if (map.containsKey("volume")) {
            Object object2 = map.get("volume");
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Float");
            volume = ((Float)object2).floatValue();
        }
        float pitch = 1.0f;
        if (map.containsKey("pitch")) {
            Object object3 = map.get("pitch");
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.Float");
            pitch = ((Float)object3).floatValue();
        }
        Object object4 = map.get("category");
        Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.String");
        XSound.Category category = XSound.Category.valueOf((String)((String)object4));
        Sound.Builder builder = Sound.Companion.builder();
        Object t = sound.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        return builder.sound((XSound)t).volume(volume).pitch(pitch).category(category).build();
    }
}

