/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.obsidian.logger.impl;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.devadri.obsidian.ObsidianPlugin;
import me.devadri.obsidian.colors.Colors;
import me.devadri.obsidian.logger.Logger;
import me.devadri.obsidian.logger.builder.LogBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J!\u0010\u0014\u001a\u00020\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u0017\u00a2\u0006\u0002\b\u0019H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lme/devadri/obsidian/logger/impl/LoggerImpl;", "Ljava/util/logging/Logger;", "Lme/devadri/obsidian/logger/Logger;", "name", "", "parent", "<init>", "(Ljava/lang/String;Ljava/util/logging/Logger;)V", "plugin", "Lme/devadri/obsidian/ObsidianPlugin;", "(Lme/devadri/obsidian/ObsidianPlugin;Ljava/util/logging/Logger;)V", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "parseMessage", "msg", "", "log", "", "builder", "Lkotlin/Function1;", "Lme/devadri/obsidian/logger/builder/LogBuilder;", "Lkotlin/ExtensionFunctionType;", "record", "Ljava/util/logging/LogRecord;", "core"})
public final class LoggerImpl
extends java.util.logging.Logger
implements Logger {
    private boolean debug;

    public LoggerImpl(@NotNull String name, @Nullable java.util.logging.Logger parent) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name, null);
        this.setParent(parent);
        this.setLevel(Level.ALL);
    }

    public /* synthetic */ LoggerImpl(String string, java.util.logging.Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = Bukkit.getServer().getLogger();
        }
        this(string, logger);
    }

    public LoggerImpl(@NotNull ObsidianPlugin plugin, @Nullable java.util.logging.Logger parent) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        String string = plugin.getDescription().getPrefix();
        if (string == null) {
            String string2 = plugin.getDescription().getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        }
        this(string, parent);
    }

    public /* synthetic */ LoggerImpl(ObsidianPlugin obsidianPlugin, java.util.logging.Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = Bukkit.getServer().getLogger();
        }
        this(obsidianPlugin, logger);
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    private final String parseMessage(Object msg) {
        String string;
        if (msg instanceof Component) {
            String string2 = LegacyComponentSerializer.legacyAmpersand().serialize((Component)msg);
            Intrinsics.checkNotNull(string2);
            string = string2;
        } else {
            string = msg.toString();
        }
        return string;
    }

    @Override
    public void log(@NotNull Function1<? super LogBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        LogBuilder logBuilder = new LogBuilder();
        builder.invoke(logBuilder);
        LogBuilder log = logBuilder;
        if (log.getDebug() && !this.getDebug()) {
            return;
        }
        if (!log.isMessageInitialized()) {
            throw new IllegalArgumentException("Cannot log empty message");
        }
        String prefix = log.getDebug() ? "[DEBUG] " : "";
        String message = this.parseMessage(log.getMessage());
        super.log(log.getLevel(), prefix + message, log.getThrowable());
    }

    @Override
    public void log(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        String string = record.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        record.setMessage(Colors.legacyToAnsi(string));
        super.log(record);
    }
}

