/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.obsidian.lib.libby;

import java.net.URLClassLoader;
import java.nio.file.Path;
import me.devadri.obsidian.lib.libby.LibraryManager;
import me.devadri.obsidian.lib.libby.classloader.ClassLoaderHelper;
import me.devadri.obsidian.lib.libby.classloader.SystemClassLoaderHelper;
import me.devadri.obsidian.lib.libby.classloader.URLClassLoaderHelper;
import me.devadri.obsidian.lib.libby.logging.adapters.LogAdapter;
import org.jetbrains.annotations.NotNull;

public class StandaloneLibraryManager
extends LibraryManager {
    @NotNull
    private final ClassLoaderHelper classLoaderHelper;

    public StandaloneLibraryManager(@NotNull LogAdapter logAdapter, @NotNull Path dataDirectory) {
        this(logAdapter, dataDirectory, "lib");
    }

    public StandaloneLibraryManager(@NotNull LogAdapter logAdapter, @NotNull Path dataDirectory, @NotNull String directoryName) {
        super(logAdapter, dataDirectory, directoryName);
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            this.classLoaderHelper = new URLClassLoaderHelper((URLClassLoader)classLoader, this);
        } else if (classLoader == ClassLoader.getSystemClassLoader()) {
            this.classLoaderHelper = new SystemClassLoaderHelper(classLoader, this);
        } else {
            throw new RuntimeException("Unsupported class loader: " + classLoader.getClass().getName());
        }
    }

    @Override
    protected void addToClasspath(@NotNull Path file) {
        this.classLoaderHelper.addToClasspath(file);
    }
}

