/*
 * Decompiled with CFR 0.152.
 */
package me.devadri.obsidian.command.manager;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.devadri.obsidian.ObsidianPlugin;
import me.devadri.obsidian.command.Command;
import me.devadri.obsidian.util.ClassUtil;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\b\u001a\u00020\u0013J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lme/devadri/obsidian/command/manager/CommandManager;", "", "plugin", "Lme/devadri/obsidian/ObsidianPlugin;", "<init>", "(Lme/devadri/obsidian/ObsidianPlugin;)V", "getPlugin", "()Lme/devadri/obsidian/ObsidianPlugin;", "syncCommands", "Ljava/lang/reflect/Method;", "_commands", "", "Lme/devadri/obsidian/command/Command;", "commands", "", "getCommands", "()Ljava/util/List;", "findSyncCommandsMethod", "registerCommand", "", "command", "unRegisterCommand", "getCommand", "Ljava/util/Optional;", "name", "", "getCommandOrNull", "core"})
public final class CommandManager {
    @NotNull
    private final ObsidianPlugin plugin;
    @Nullable
    private final Method syncCommands;
    @NotNull
    private final List<Command> _commands;

    public CommandManager(@NotNull ObsidianPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.syncCommands = this.findSyncCommandsMethod();
        this._commands = new ArrayList();
    }

    @NotNull
    public final ObsidianPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final List<Command> getCommands() {
        return CollectionsKt.toList((Iterable)this._commands);
    }

    private final Method findSyncCommandsMethod() {
        Method method;
        if (ClassUtil.classExists("org.mockbukkit.mockbukkit.MockBukkit")) {
            return null;
        }
        try {
            Method method2 = Bukkit.getServer().getClass().getDeclaredMethod("syncCommands", new Class[0]);
            method2.setAccessible(true);
        }
        catch (Exception e) {
            this.plugin.logger.error("Could not find syncCommands method", e);
            method = null;
        }
        return method;
    }

    public final void registerCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter(command, "command");
        command.register();
        this._commands.add(command);
    }

    public final void unRegisterCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter(command, "command");
        command.unRegister();
        this._commands.remove(command);
    }

    public final void syncCommands() {
        try {
            Method method = this.syncCommands;
            if (method != null) {
                method.invoke((Object)Bukkit.getServer(), new Object[0]);
            }
        }
        catch (Throwable e) {
            this.plugin.logger.error("Could not sync commands", e);
        }
    }

    @NotNull
    public final Optional<Command> getCommand(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Optional<Object> optional = Bukkit.getCommandMap().getKnownCommands().values().stream().filter(arg_0 -> CommandManager.getCommand$lambda$1(CommandManager::getCommand$lambda$0, arg_0)).map(arg_0 -> CommandManager.getCommand$lambda$3(CommandManager::getCommand$lambda$2, arg_0)).filter(arg_0 -> CommandManager.getCommand$lambda$5(arg_0 -> CommandManager.getCommand$lambda$4(this, arg_0), arg_0)).filter(arg_0 -> CommandManager.getCommand$lambda$7(arg_0 -> CommandManager.getCommand$lambda$6(name, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, "findFirst(...)");
        return optional;
    }

    @Nullable
    public final Command getCommandOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.getCommand(name).orElse(null);
    }

    private static final boolean getCommand$lambda$0(org.bukkit.command.Command it) {
        return it instanceof Command;
    }

    private static final boolean getCommand$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Command getCommand$lambda$2(org.bukkit.command.Command it) {
        Intrinsics.checkNotNull(it, "null cannot be cast to non-null type me.devadri.obsidian.command.Command");
        return (Command)it;
    }

    private static final Command getCommand$lambda$3(Function1 $tmp0, Object p0) {
        return (Command)$tmp0.invoke(p0);
    }

    private static final boolean getCommand$lambda$4(CommandManager this$0, Command it) {
        return Intrinsics.areEqual((Object)it.getPlugin(), (Object)this$0.plugin);
    }

    private static final boolean getCommand$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getCommand$lambda$6(String $name, Command it) {
        return Intrinsics.areEqual(it.getInfo().getName(), $name);
    }

    private static final boolean getCommand$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

