/*
 * Decompiled with CFR 0.152.
 */
package me.adrigamer2950.playertracer.logs;

import io.papermc.paper.event.player.AsyncChatEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.adrigamer2950.playertracer.PlayerTracerPlugin;
import me.adrigamer2950.playertracer.logs.ChatLog;
import me.adrigamer2950.playertracer.logs.CommandLog;
import me.adrigamer2950.playertracer.logs.JoinServerLog;
import me.adrigamer2950.playertracer.logs.LeaveServerLog;
import me.adrigamer2950.playertracer.logs.LogsManager;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/adrigamer2950/playertracer/logs/LogsListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lme/adrigamer2950/playertracer/PlayerTracerPlugin;", "<init>", "(Lme/adrigamer2950/playertracer/PlayerTracerPlugin;)V", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerChat", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onPlayerCommand", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "PlayerTracer"})
public final class LogsListener
implements Listener {
    @NotNull
    private final PlayerTracerPlugin plugin;

    public LogsListener(@NotNull PlayerTracerPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LogsManager logsManager = this.plugin.getLogsManager();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        logsManager.addLog(new JoinServerLog(player));
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LogsManager logsManager = this.plugin.getLogsManager();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        logsManager.addLog(new LeaveServerLog(player));
    }

    @EventHandler
    public final void onPlayerChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LogsManager logsManager = this.plugin.getLogsManager();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Component component = event.message();
        Intrinsics.checkNotNullExpressionValue(component, "message(...)");
        logsManager.addLog(new ChatLog(player, component));
    }

    @EventHandler
    public final void onPlayerCommand(@NotNull PlayerCommandPreprocessEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LogsManager logsManager = this.plugin.getLogsManager();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        String string = event.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        logsManager.addLog(new CommandLog(player, string));
    }
}

