/*
 * Decompiled with CFR 0.152.
 */
package me.adrigamer2950.playertracer.commands.subcommands;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.adrigamer2950.playertracer.api.logs.Log;
import me.adrigamer2950.playertracer.api.logs.LogData;
import me.adrigamer2950.playertracer.api.util.StaticFunctionsKt;
import me.adrigamer2950.playertracer.commands.AbstractPLCommand;
import me.adrigamer2950.playertracer.commands.subcommands.SearchSubCommand;
import me.adrigamer2950.playertracer.util.Permission;
import me.adrigamer2950.playertracer.util.TimeUtil;
import me.devadri.obsidian.ExtensionsKt;
import me.devadri.obsidian.user.User;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J-\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/adrigamer2950/playertracer/commands/subcommands/PageSubCommand;", "Lme/adrigamer2950/playertracer/commands/AbstractPLCommand;", "<init>", "()V", "getDisplayName", "", "rootCommandName", "execute", "", "user", "Lme/devadri/obsidian/user/User;", "args", "", "commandName", "(Lme/devadri/obsidian/user/User;[Ljava/lang/String;Ljava/lang/String;)V", "PlayerTracer"})
@SourceDebugExtension(value={"SMAP\nPageSubCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageSubCommand.kt\nme/adrigamer2950/playertracer/commands/subcommands/PageSubCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1869#2,2:78\n*S KotlinDebug\n*F\n+ 1 PageSubCommand.kt\nme/adrigamer2950/playertracer/commands/subcommands/PageSubCommand\n*L\n52#1:78,2\n*E\n"})
public final class PageSubCommand
extends AbstractPLCommand {
    public PageSubCommand() {
        super("page", "Shows the specified page of the current search", CollectionsKt.listOf("p"));
    }

    @Override
    @NotNull
    public String getDisplayName(@NotNull String rootCommandName) {
        Intrinsics.checkNotNullParameter(rootCommandName, "rootCommandName");
        return rootCommandName + " page &c<page>";
    }

    @Override
    public void execute(@NotNull User user, @NotNull String[] args, @NotNull String commandName) {
        UUID uUID;
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(args, "args");
        Intrinsics.checkNotNullParameter(commandName, "commandName");
        Map<UUID, List<Log>> map = SearchSubCommand.Companion.getCache();
        if (ExtensionsKt.isConsole(user)) {
            uUID = null;
        } else {
            Player player = ExtensionsKt.asPlayer(user);
            Intrinsics.checkNotNull(player);
            uUID = player.getUniqueId();
        }
        List<Log> list = map.get(uUID);
        if (list == null) {
            PageSubCommand $this$execute_u24lambda_u240 = this;
            boolean bl = false;
            String[] stringArray = new String[]{"&cNo search results found. Please run a search first."};
            user.sendMessage(stringArray);
            return;
        }
        List<Log> logs = list;
        if (args.length == 0) {
            String[] stringArray = new String[]{"&cUsage: /" + this.getDisplayName(commandName)};
            user.sendMessage(stringArray);
            return;
        }
        Integer n = StringsKt.toIntOrNull(args[0]);
        if (n == null) {
            PageSubCommand $this$execute_u24lambda_u241 = this;
            boolean bl = false;
            String[] stringArray = new String[]{"&cInvalid page number. Please provide a valid integer."};
            user.sendMessage(stringArray);
            return;
        }
        int pageNumber = n;
        int totalPages = logs.size() / 7 + (logs.size() % 7 > 0 ? 1 : 0);
        if (pageNumber < 1 || pageNumber > totalPages) {
            String[] $this$execute_u24lambda_u240 = new String[]{"&cInvalid page number. Please provide a number between 1 and " + totalPages};
            user.sendMessage($this$execute_u24lambda_u240);
            return;
        }
        List<Log> pagedLogs = logs.subList(0, pageNumber * 7 > logs.size() ? logs.size() : pageNumber * 7);
        String[] $this$execute_u24lambda_u241 = new String[]{"&7--------- &bSearch Results &7---------"};
        user.sendMessage($this$execute_u24lambda_u241);
        $this$execute_u24lambda_u241 = new String[]{"&7Page " + pageNumber + " of " + totalPages};
        user.sendMessage($this$execute_u24lambda_u241);
        Iterable $this$forEach$iv = pagedLogs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Log it = (Log)element$iv;
            boolean bl = false;
            String time = "[" + TimeUtil.INSTANCE.formatTimeAgo(it.getTimestamp()) + "]";
            LogData data = this.getPlugin().getLogsProvider().getData(Reflection.getOrCreateKotlinClass(it.getClass()));
            Component[] componentArray = new Component[]{StaticFunctionsKt.miniMessage("<hover:show_text:'" + TimeUtil.INSTANCE.timestampToDate(it.getTimestamp()) + "'><gray>" + time + "</hover> <aqua>" + it.getOfflinePlayer().getName() + "<gray> | <white>" + data.getDisplayName() + "</white>: " + it.getMessage())};
            user.sendMessage(componentArray);
            if (!Permission.isGrantedTo-impl(Permission.Companion.getTELEPORT-nCx_hmM(), user)) continue;
            String teleportCommand = "/" + commandName + " tp " + it.getLocation().getWorldName() + " " + it.getLocation().getX() + " " + it.getLocation().getY() + " " + it.getLocation().getZ();
            String space = StringsKt.repeat(" ", time.length());
            Component[] componentArray2 = new Component[]{StaticFunctionsKt.miniMessage("<hover:show_text:'" + teleportCommand + "'><gray>" + space + " (" + it.getLocation().getWorldName() + "/x" + it.getLocation().getX() + "/y" + it.getLocation().getY() + "/z" + it.getLocation().getZ() + ")</hover>").clickEvent(ClickEvent.runCommand((String)teleportCommand))};
            user.sendMessage(componentArray2);
        }
        String[] stringArray = new String[]{"&7--------- &bEnd of results &7---------"};
        user.sendMessage(stringArray);
    }
}

