/*
 * Decompiled with CFR 0.152.
 */
package me.adrigamer2950.playertracer.util;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/adrigamer2950/playertracer/util/TimeUtil;", "", "<init>", "()V", "ONE_MINUTE", "", "ONE_HOUR", "ONE_DAY", "ONE_WEEK", "ONE_MONTH", "ONE_YEAR", "parseDuration", "Ljava/sql/Timestamp;", "duration", "", "formatTimeAgo", "timestamp", "", "timestampToDate", "PlayerTracer"})
public final class TimeUtil {
    @NotNull
    public static final TimeUtil INSTANCE = new TimeUtil();
    public static final int ONE_MINUTE = 60;
    public static final int ONE_HOUR = 3600;
    public static final int ONE_DAY = 86400;
    public static final int ONE_WEEK = 604800;
    public static final int ONE_MONTH = 2592000;
    public static final int ONE_YEAR = 31536000;

    private TimeUtil() {
    }

    @NotNull
    public final Timestamp parseDuration(@NotNull String duration) {
        Intrinsics.checkNotNullParameter(duration, "duration");
        Regex regex = new Regex("(\\d+)([smhdw])");
        String string = duration.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        MatchResult matchResult = regex.matchEntire(string);
        if (matchResult == null) {
            throw new IllegalArgumentException("Invalid format: " + duration);
        }
        MatchResult match = matchResult;
        MatchResult.Destructured destructured = match.getDestructured();
        String amountStr = destructured.getMatch().getGroupValues().get(1);
        String unit = destructured.getMatch().getGroupValues().get(2);
        long amount = Long.parseLong(amountStr);
        Instant instant = Instant.now();
        Timestamp timestamp = Timestamp.from(instant.minus(switch (unit) {
            case "s" -> Duration.ofSeconds(amount);
            case "m" -> Duration.ofMinutes(amount);
            case "h" -> Duration.ofHours(amount);
            case "d" -> Duration.ofDays(amount);
            case "w" -> Duration.ofDays(amount * (long)7);
            default -> throw new IllegalArgumentException("Unrecognised time unit: " + unit);
        }));
        Intrinsics.checkNotNullExpressionValue(timestamp, "from(...)");
        return timestamp;
    }

    @NotNull
    public final String formatTimeAgo(long timestamp) {
        long years;
        long months;
        long weeks;
        long days;
        long hours;
        long minutes;
        Instant timestamp2 = Instant.ofEpochMilli(timestamp);
        Instant now = Instant.now();
        long seconds = Duration.between(timestamp2, now).getSeconds();
        return seconds < 60L ? seconds + " second" + (seconds != 1L ? "s" : "") + " ago" : (seconds < 3600L ? minutes + " minute" + ((minutes = seconds / (long)60) != 1L ? "s" : "") + " ago" : (seconds < 86400L ? hours + " hour" + ((hours = seconds / (long)3600) != 1L ? "s" : "") + " ago" : (seconds < 604800L ? days + " day" + ((days = seconds / (long)86400) != 1L ? "s" : "") + " ago" : (seconds < 2592000L ? weeks + " week" + ((weeks = seconds / (long)604800) != 1L ? "s" : "") + " ago" : (seconds < 31536000L ? months + " month" + ((months = seconds / (long)2592000) != 1L ? "s" : "") + " ago" : years + " year" + ((years = seconds / (long)31536000) != 1L ? "s" : "") + " ago")))));
    }

    @NotNull
    public final String timestampToDate(long timestamp) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss a");
        String string = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime().format(formatter);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }
}

