/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.util;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.FarmQuest;

public class Wrapper {
    private final FarmQuest plugin;
    private final int version;

    public Wrapper(@NotNull FarmQuest plugin) {
        this.plugin = plugin;
        this.version = this.fetchVersion();
    }

    private int fetchVersion() {
        int version;
        CharSequence[] ver = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        if (ver.length < 2) {
            Util.log("{WARN}Could not fetch server version!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        int major = 0;
        try {
            major = Integer.parseInt(ver[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int minor = 0;
        if (ver.length >= 3) {
            try {
                minor = Integer.parseInt(ver[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((version = major * 10 + minor) < 170) {
            Util.log(String.format("&cYou are using an unsupported server version '%s'!", String.join((CharSequence)".", ver)), "&cPlease use v1.17 or newer.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        return version;
    }

    @Generated
    public FarmQuest getPlugin() {
        return this.plugin;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }
}

