/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.FarmQuest;

public class UpdateChecker {
    private final int resourceId;
    private final FarmQuest plugin;

    public UpdateChecker(FarmQuest plugin, int resourceId) {
        this.resourceId = resourceId;
        this.plugin = plugin;
    }

    private void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId + "/~").openStream();
                 Scanner scann = new Scanner(is);){
                if (scann.hasNext()) {
                    consumer.accept(scann.next());
                }
            }
            catch (IOException e) {
                Util.log("&cUnable to check for updates: " + e.getMessage());
            }
        });
    }

    public void inform() {
        FileConfiguration config = this.plugin.configRegistry.getConfig();
        if (!config.getBoolean("update_check", true)) {
            return;
        }
        this.getVersion(version -> {
            if (this.plugin.getDescription().getVersion().equals(version)) {
                Util.log("{WHITE}You are up to date!");
            } else {
                Util.log("{WARN}You are not up to date. (Latest release: " + version + ")");
                Util.log("{WARN}Open this link to update the plugin. https://www.spigotmc.org/resources/farmquest." + this.resourceId + "/");
            }
        });
    }
}

