/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.service.registry;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.object.DMaterial;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.model.quest.QuestProperty;
import org.nandayo.farmquest.model.quest.Reward;
import org.nandayo.farmquest.service.registry.Registry;

public class QuestRegistry
extends Registry {
    public QuestRegistry(@NotNull FarmQuest plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getFilePath() {
        return "database/quests.yml";
    }

    @Override
    public void load() {
        Quest.getRegisteredQuests().clear();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.getFile());
        ConfigurationSection quests = config.getConfigurationSection("quests");
        if (quests == null) {
            return;
        }
        for (String id : quests.getKeys(false)) {
            String name = quests.getString(id + ".name", "Unknown");
            String description = quests.getString(id + ".description", "Unknown");
            DMaterial dIcon = DMaterial.getByName(quests.getString(id + ".icon", "PAPER"));
            Material icon = dIcon.parseMaterial() == null ? Material.PAPER : dIcon.parseMaterial();
            Objective.ObjectiveType type = Objective.ObjectiveType.get(quests.getString(id + ".objective.type", ""));
            FarmBlock farmBlock = FarmBlock.get(quests.getString(id + ".objective.farm_block", ""));
            int targetAmount = quests.getInt(id + ".objective.target_amount", 0);
            long timeLimit = quests.getLong(id + ".objective.time_limit", 0L);
            if (type == null) {
                Util.log("{WARN}ObjectiveType for Quest '" + id + "' is null.");
                continue;
            }
            if (farmBlock == null) {
                Util.log("{WARN}FarmBlock for Quest '" + id + "' is null.");
                continue;
            }
            ArrayList<Reward> rewards = new ArrayList<Reward>();
            for (Reward.RewardType rewardType : Reward.RewardType.values()) {
                String rewardNamespace = id + ".rewards." + rewardType.name();
                List run = quests.getStringList(rewardNamespace);
                rewards.add(new Reward(rewardType, run));
            }
            QuestProperty questProperty = new QuestProperty();
            for (QuestProperty.Property property : questProperty.values()) {
                property.setEnabled(quests.getBoolean(id + ".property." + property.getString(), false));
            }
            new Quest(type, farmBlock, targetAmount, timeLimit, rewards, questProperty, id, name, description, icon).register();
        }
        Util.log("Loaded " + Quest.getRegisteredQuests().size() + " quests.");
    }

    @Override
    public void save() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.getFile());
        config.set("quests", null);
        for (Quest quest : Quest.getRegisteredQuests()) {
            String namespace = "quests." + quest.getId();
            config.set(namespace + ".name", (Object)quest.getName());
            config.set(namespace + ".description", (Object)quest.getDescription());
            config.set(namespace + ".icon", (Object)quest.getIcon().toString());
            config.set(namespace + ".objective.type", (Object)quest.getType().toString());
            config.set(namespace + ".objective.farm_block", (Object)quest.getFarmBlock().toString());
            config.set(namespace + ".objective.target_amount", (Object)quest.getTargetAmount());
            config.set(namespace + ".objective.time_limit", (Object)quest.getTimeLimit());
            for (Reward.RewardType rewardType : Reward.RewardType.values()) {
                Reward reward = quest.getReward(rewardType);
                if (reward == null) continue;
                config.set(namespace + ".rewards." + rewardType.name(), reward.getRun());
            }
            for (QuestProperty.Property property : quest.getQuestProperty().values()) {
                config.set(namespace + ".property." + property.getString(), (Object)property.isEnabled());
            }
        }
        try {
            config.save(this.getFile());
        }
        catch (IOException e) {
            Util.log("{WARN}Couldn't save Quests configuration.");
            e.printStackTrace();
        }
    }
}

