/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.quest;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.model.quest.QuestProperty;
import org.nandayo.farmquest.model.quest.Reward;

public class WritableQuest {
    @NotNull
    private Objective.ObjectiveType type = Objective.ObjectiveType.HARVEST;
    @NotNull
    private FarmBlock farmBlock = FarmBlock.CACTUS;
    private int targetAmount = 10;
    private long timeLimit = 60L;
    @NotNull
    private Collection<Reward> rewards = new ArrayList<Reward>();
    @NotNull
    private QuestProperty questProperty = new QuestProperty();
    @NotNull
    private final String id;
    @NotNull
    private String name;
    @NotNull
    private String description = "";
    @Nullable
    private Material icon;

    public WritableQuest(@NotNull String id) {
        this.id = id;
        this.name = "Quest #" + id;
    }

    public WritableQuest(@NotNull Objective.ObjectiveType type, @NotNull FarmBlock farmBlock, int targetAmount, long timeLimit, @NotNull Collection<Reward> rewards, @NotNull QuestProperty questProperty, @NotNull String id, @NotNull String name, @NotNull String description, @NotNull Material icon) {
        this.type = type;
        this.farmBlock = farmBlock;
        this.targetAmount = targetAmount;
        this.timeLimit = timeLimit;
        this.rewards = rewards;
        this.questProperty = questProperty;
        this.id = id;
        this.name = name;
        this.description = description;
        this.icon = icon;
    }

    @NotNull
    public Material getIcon() {
        return this.icon != null ? this.icon : this.farmBlock.getSeedMaterial();
    }

    public void setIcon(@Nullable Material icon) {
        this.icon = icon == null || !icon.isItem() ? null : icon;
    }

    public void setTargetAmount(int targetAmount) {
        this.targetAmount = Math.max(1, targetAmount);
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = Math.max(1L, timeLimit);
    }

    @Nullable
    public Reward getReward(@NotNull Reward.RewardType type) {
        return this.rewards.stream().filter(r -> r.getType().equals((Object)type)).findFirst().orElse(null);
    }

    @NotNull
    public Reward getRewardOrCreate(@NotNull Reward.RewardType type) {
        Reward reward = this.getReward(type);
        if (reward != null) {
            return reward;
        }
        reward = new Reward(type, new ArrayList<String>());
        this.rewards.add(reward);
        return reward;
    }

    @Nullable
    public Quest createQuest() {
        if (Quest.getQuest(this.id) != null) {
            Util.log("Quest already exists with id '" + this.id + "'!");
            return null;
        }
        return new Quest(this.type, this.farmBlock, this.targetAmount, this.timeLimit, this.rewards, this.questProperty, this.id, this.name, this.description, this.icon);
    }

    @Nullable
    public Quest saveToQuest(@NotNull String id) {
        Quest oldQuest = Quest.getQuest(id);
        if (oldQuest == null) {
            Util.log("Quest with id '" + id + "' does not exist!");
            return null;
        }
        Quest newQuest = new Quest(this.type, this.farmBlock, this.targetAmount, this.timeLimit, this.rewards, this.questProperty, id, this.name, this.description, this.icon);
        oldQuest.replaceWith(newQuest);
        return newQuest;
    }

    @Nullable
    public Quest saveToQuest() {
        return this.saveToQuest(this.id);
    }

    @NotNull
    public static WritableQuest fromQuest(@NotNull Quest quest) {
        return new WritableQuest(quest.getType(), quest.getFarmBlock(), quest.getTargetAmount(), quest.getTimeLimit(), quest.getRewards(), quest.getQuestProperty(), quest.getId(), quest.getName(), quest.getDescription(), quest.getIcon());
    }

    @NotNull
    @Generated
    public Objective.ObjectiveType getType() {
        return this.type;
    }

    @NotNull
    @Generated
    public FarmBlock getFarmBlock() {
        return this.farmBlock;
    }

    @Generated
    public int getTargetAmount() {
        return this.targetAmount;
    }

    @Generated
    public long getTimeLimit() {
        return this.timeLimit;
    }

    @NotNull
    @Generated
    public Collection<Reward> getRewards() {
        return this.rewards;
    }

    @NotNull
    @Generated
    public QuestProperty getQuestProperty() {
        return this.questProperty;
    }

    @NotNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setType(@NotNull Objective.ObjectiveType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @Generated
    public void setFarmBlock(@NotNull FarmBlock farmBlock) {
        if (farmBlock == null) {
            throw new NullPointerException("farmBlock is marked non-null but is null");
        }
        this.farmBlock = farmBlock;
    }

    @Generated
    public void setRewards(@NotNull Collection<Reward> rewards) {
        if (rewards == null) {
            throw new NullPointerException("rewards is marked non-null but is null");
        }
        this.rewards = rewards;
    }

    @Generated
    public void setQuestProperty(@NotNull QuestProperty questProperty) {
        if (questProperty == null) {
            throw new NullPointerException("questProperty is marked non-null but is null");
        }
        this.questProperty = questProperty;
    }

    @Generated
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setDescription(@NotNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }
}

