/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.quest;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.nandayo.farmquest.model.Farmer;

public class Reward {
    @NotNull
    private final RewardType type;
    @NotNull
    private List<String> run;

    public Reward(@NotNull RewardType type, @NotNull List<String> run) {
        this.type = type;
        this.run = new ArrayList<String>(run);
    }

    public void setRun(@NotNull List<String> run) {
        this.run = new ArrayList<String>(run);
    }

    public void grant(@NotNull Farmer farmer) {
        if (farmer.getPlayer().isEmpty()) {
            return;
        }
        Player player = farmer.getPlayer().get();
        if (this.type == RewardType.COMMAND) {
            for (String cmd : this.run) {
                String fixedCmd = cmd.replace("%player_name%", player.getName()).trim();
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)fixedCmd);
            }
        }
    }

    @NotNull
    @Generated
    public RewardType getType() {
        return this.type;
    }

    @NotNull
    @Generated
    public List<String> getRun() {
        return this.run;
    }

    public static enum RewardType {
        COMMAND(Material.COMMAND_BLOCK_MINECART),
        FARM_TOOL(Material.GOLDEN_HOE);

        private final Material icon;

        private RewardType(Material icon) {
            this.icon = icon;
        }

        public static RewardType get(@NotNull String name) {
            try {
                return RewardType.valueOf(name.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Generated
        public Material getIcon() {
            return this.icon;
        }
    }
}

