/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.quest;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.model.farm.Farm;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.QuestProgress;
import org.nandayo.farmquest.model.quest.QuestProperty;
import org.nandayo.farmquest.model.quest.Reward;

public class Quest
extends Objective {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @Nullable
    private Material icon;
    private static final Collection<Quest> registeredQuests = new ArrayList<Quest>();

    public Quest(@NotNull Objective.ObjectiveType type, @NotNull FarmBlock farmBlock, int targetAmount, long timeLimit, @NotNull Collection<Reward> rewards, @NotNull QuestProperty questProperty, @NotNull String id, @NotNull String name, @NotNull String description, @Nullable Material icon) {
        super(type, farmBlock, targetAmount, timeLimit, rewards, questProperty);
        this.id = id;
        this.name = name;
        this.description = description;
        this.icon = icon;
    }

    public Quest(@NotNull Objective.ObjectiveType type, @NotNull FarmBlock farmBlock, int targetAmount, long timeLimit, @NotNull Collection<Reward> rewards, @NotNull QuestProperty questProperty, @NotNull String name, @NotNull String description, @Nullable Material icon) {
        this(type, farmBlock, targetAmount, timeLimit, rewards, questProperty, Util.generateRandomLowerCaseString(2), name, description, icon);
    }

    public void register() {
        if (Quest.getQuest(this.id) == null) {
            registeredQuests.add(this);
        }
    }

    public void unregister() {
        registeredQuests.remove(this);
        this.questDeletion();
    }

    public void questDeletion() {
        for (Farmer farmer : Farmer.getPlayers()) {
            QuestProgress questProgress = farmer.getActiveQuestProgress();
            if (questProgress == null || !questProgress.getQuest().equals(this)) continue;
            farmer.dropQuest(false);
            farmer.tell(FarmQuest.getInstance().languageUtil.getString("quest_was_deleted"));
        }
        for (Farm farm : Farm.getRegisteredFarms()) {
            if (!farm.getQuests().contains(this)) continue;
            farm.getQuests().remove(this);
        }
    }

    public void replaceWith(@NotNull Quest quest) {
        registeredQuests.remove(this);
        quest.register();
        for (Farmer farmer : Farmer.getPlayers()) {
            QuestProgress questProgress = farmer.getActiveQuestProgress();
            if (questProgress == null || !questProgress.getQuest().equals(this)) continue;
            farmer.dropQuest(false);
            farmer.tell(FarmQuest.getInstance().languageUtil.getString("quest_was_deleted"));
        }
        for (Farm farm : Farm.getRegisteredFarms()) {
            if (!farm.getQuests().contains(this)) continue;
            farm.getQuests().remove(this);
            farm.getQuests().add(quest);
        }
    }

    @NotNull
    public Material getIcon() {
        return this.icon != null ? this.icon : this.getFarmBlock().getSeedMaterial();
    }

    public void setIcon(@Nullable Material icon) {
        this.icon = icon == null || !icon.isItem() ? null : icon;
    }

    @Nullable
    public QuestProgress freshProgress(@NotNull Farm farm) {
        if (!farm.getQuests().contains(this)) {
            return null;
        }
        return new QuestProgress(this, farm, 0, Instant.now().getEpochSecond());
    }

    @Nullable
    public static Quest getQuest(@NotNull String id) {
        return registeredQuests.stream().filter(q -> q.getId().equals(id)).findFirst().orElse(null);
    }

    @NotNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public static Collection<Quest> getRegisteredQuests() {
        return registeredQuests;
    }
}

