/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.quest;

import java.util.Collection;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.model.quest.QuestProperty;
import org.nandayo.farmquest.model.quest.Reward;

public class Objective {
    @NotNull
    private final ObjectiveType type;
    @NotNull
    private final FarmBlock farmBlock;
    private final int targetAmount;
    private final long timeLimit;
    @NotNull
    private final Collection<Reward> rewards;
    @NotNull
    private final QuestProperty questProperty;

    public Objective(@NotNull ObjectiveType type, @NotNull FarmBlock farmBlock, int targetAmount, long timeLimit, @NotNull Collection<Reward> rewards, @NotNull QuestProperty questProperty) {
        this.type = type;
        this.farmBlock = farmBlock;
        this.targetAmount = targetAmount;
        this.timeLimit = timeLimit;
        this.rewards = rewards;
        this.questProperty = questProperty;
    }

    @Nullable
    public Reward getReward(@NotNull Reward.RewardType type) {
        return this.rewards.stream().filter(r -> r.getType().equals((Object)type)).findFirst().orElse(null);
    }

    public void grantRewards(@NotNull Farmer farmer) {
        for (Reward reward : this.rewards) {
            reward.grant(farmer);
        }
    }

    @NotNull
    @Generated
    public ObjectiveType getType() {
        return this.type;
    }

    @NotNull
    @Generated
    public FarmBlock getFarmBlock() {
        return this.farmBlock;
    }

    @Generated
    public int getTargetAmount() {
        return this.targetAmount;
    }

    @Generated
    public long getTimeLimit() {
        return this.timeLimit;
    }

    @NotNull
    @Generated
    public Collection<Reward> getRewards() {
        return this.rewards;
    }

    @NotNull
    @Generated
    public QuestProperty getQuestProperty() {
        return this.questProperty;
    }

    public static enum ObjectiveType {
        HARVEST("Harvest", Material.IRON_HOE),
        PLANT("Plant", Material.FLOWER_POT),
        DELIVER("Deliver", Material.BUNDLE);

        private final String displayName;
        private final Material icon;

        private ObjectiveType(String displayName, Material icon) {
            this.displayName = displayName;
            this.icon = icon;
        }

        @Nullable
        public static ObjectiveType get(@NotNull String name) {
            try {
                return ObjectiveType.valueOf(name.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public Material getIcon() {
            return this.icon;
        }
    }
}

