/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.farm;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.model.farm.FarmRegion;
import org.nandayo.farmquest.model.quest.Quest;

public class Farm {
    private final String id;
    private final FarmRegion region;
    private final Collection<Quest> quests;
    private static final Collection<Farm> registeredFarms = new ArrayList<Farm>();

    public Farm(@NotNull String id, @NotNull FarmRegion region, @NotNull Collection<Quest> quests) {
        if (!id.matches("[a-z0-9]{8}")) {
            throw new IllegalArgumentException("Invalid Farm ID. (Does not match [a-z0-9]{8}).");
        }
        this.id = id;
        this.region = region;
        this.quests = new ArrayList<Quest>(quests);
    }

    public Farm(@NotNull String id, @NotNull FarmRegion region) {
        this(id, region, new ArrayList<Quest>());
    }

    public void register() {
        if (!registeredFarms.contains(this)) {
            registeredFarms.add(this);
        } else {
            Util.log(String.format("{WARN}Farm with id '%s' was already registered.", this.id));
        }
    }

    public void unregister() {
        registeredFarms.remove(this);
    }

    public boolean linkQuest(@NotNull Quest quest) {
        if (this.quests.contains(quest)) {
            return false;
        }
        this.quests.add(quest);
        return true;
    }

    public boolean unlinkQuest(@NotNull Quest quest) {
        return this.quests.remove(quest);
    }

    @Nullable
    public static Farm getFarm(@NotNull String id) {
        return registeredFarms.stream().filter(f -> f.getId().equals(id)).findFirst().orElse(null);
    }

    @Nullable
    public static Farm getFarm(@NotNull Location location) {
        return registeredFarms.stream().filter(f -> f.getRegion().isInside(location)).findFirst().orElse(null);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public FarmRegion getRegion() {
        return this.region;
    }

    @Generated
    public Collection<Quest> getQuests() {
        return this.quests;
    }

    @Generated
    public static Collection<Farm> getRegisteredFarms() {
        return registeredFarms;
    }
}

