/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.model.farm.Farm;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.model.quest.QuestProgress;

public class Farmer {
    @NotNull
    private final UUID uuid;
    @Nullable
    private QuestProgress activeQuestProgress;
    @NotNull
    private final Collection<String> completedQuests;
    @Nullable
    private KeyedBossBar bossBar;
    private static final Collection<Farmer> players = new ArrayList<Farmer>();

    public Farmer(@NotNull UUID uuid, @Nullable QuestProgress activeQuestProgress, @NotNull Collection<String> completedQuests) {
        this.uuid = uuid;
        this.activeQuestProgress = activeQuestProgress;
        this.completedQuests = new ArrayList<String>(completedQuests);
    }

    public void register() {
        if (Farmer.getPlayer(this.uuid) == null) {
            players.add(this);
        } else {
            Util.log(String.format("{WARN}Player with UUID '%s' was already registered.", this.uuid));
        }
    }

    public void unregister() {
        players.remove(this);
        KeyedBossBar bossBar = this.getBossBar();
        Player player = this.getOfflinePlayer().getPlayer();
        if (bossBar != null && player != null) {
            bossBar.removePlayer(player);
            Bukkit.removeBossBar((NamespacedKey)bossBar.getKey());
        }
    }

    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    @NotNull
    public Optional<Player> getPlayer() {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)this.uuid));
    }

    public void tell(String ... message) {
        this.getPlayer().ifPresent(p -> FarmQuest.getInstance().tell((CommandSender)p, message));
    }

    public void pickupQuest(@NotNull Quest quest, @NotNull Farm farm) {
        FarmQuest plugin = FarmQuest.getInstance();
        Optional<Player> player = this.getPlayer();
        if (this.activeQuestProgress != null) {
            this.tell(plugin.languageUtil.getString("have_active_quest"));
            player.ifPresent(p -> p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.6f, 1.0f));
            return;
        }
        if (this.completedQuests.contains(quest.getId())) {
            this.tell(plugin.languageUtil.getString("quest_already_completed"));
            player.ifPresent(p -> p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.6f, 1.0f));
            return;
        }
        QuestProgress freshProgress = quest.freshProgress(farm);
        if (freshProgress == null) {
            this.tell(plugin.languageUtil.getString("quest_is_not_linked_to_farm").replace("{farm}", farm.getId()));
            player.ifPresent(p -> p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.6f, 1.0f));
            return;
        }
        this.activeQuestProgress = freshProgress;
        if (quest.getType() == Objective.ObjectiveType.PLANT) {
            player.ifPresent(p -> {
                ItemStack seeds = ItemCreator.of(quest.getFarmBlock().getSeedMaterial()).amount(quest.getTargetAmount()).get();
                p.getInventory().addItem(new ItemStack[]{seeds});
            });
        }
        this.activeQuestProgress.startTicking(() -> {
            if (this.activeQuestProgress == null || !this.activeQuestProgress.getQuest().equals(quest)) {
                return;
            }
            this.dropQuest(false);
            this.tell(plugin.languageUtil.getString("exceed_quest_time_limit"));
        });
        this.tell(plugin.languageUtil.getString("pickup_quest").replace("{quest}", quest.getName()));
        player.ifPresent(p -> p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f));
    }

    public void continueActiveQuest() {
        if (this.activeQuestProgress == null || this.activeQuestProgress.isTicking()) {
            return;
        }
        Quest quest = this.activeQuestProgress.getQuest();
        this.activeQuestProgress.startTicking(() -> {
            if (this.activeQuestProgress == null || !this.activeQuestProgress.getQuest().equals(quest)) {
                return;
            }
            this.dropQuest(false);
            this.tell(FarmQuest.getInstance().languageUtil.getString("exceed_quest_time_limit"));
            Player player = this.getOfflinePlayer().getPlayer();
            if (player != null) {
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_STARE, 1.0f, 1.0f);
            }
        });
    }

    public void dropQuest(boolean completed) {
        if (this.activeQuestProgress == null) {
            return;
        }
        Optional<Player> player = this.getPlayer();
        if (completed) {
            this.completedQuests.add(this.activeQuestProgress.getQuest().getId());
            player.ifPresent(p -> p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 0.6f, 1.0f));
        } else {
            player.ifPresent(p -> p.playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 0.6f, 1.0f));
        }
        this.activeQuestProgress.stopTicking();
        this.activeQuestProgress = null;
    }

    @NotNull
    public KeyedBossBar getBossBarOrCreate() {
        if (this.bossBar == null) {
            this.bossBar = Bukkit.createBossBar((NamespacedKey)new NamespacedKey((Plugin)FarmQuest.getInstance(), "bossbar_" + String.valueOf(this.uuid)), (String)"Loading", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.getPlayer().ifPresent(p -> this.bossBar.addPlayer(p));
        }
        return this.bossBar;
    }

    public void save() {
        if (this.activeQuestProgress != null) {
            this.activeQuestProgress.stopTicking();
        }
        File file = new File(FarmQuest.getInstance().getDataFolder(), "players/" + String.valueOf(this.uuid) + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        config.set("active_quest.quest", this.activeQuestProgress == null ? null : this.activeQuestProgress.getQuest().getId());
        config.set("active_quest.farm", this.activeQuestProgress == null ? null : this.activeQuestProgress.getFarm().getId());
        config.set("active_quest.progress", this.activeQuestProgress == null ? null : Integer.valueOf(this.activeQuestProgress.getProgress()));
        config.set("active_quest.start_time", this.activeQuestProgress == null ? null : Long.valueOf(this.activeQuestProgress.getStartTime()));
        config.set("completed_quests", this.completedQuests);
        this.unregister();
        try {
            config.save(file);
        }
        catch (IOException e) {
            Util.log(String.format("{WARN}Couldn't save player data for '%s'.", this.uuid));
            e.printStackTrace();
        }
    }

    @Nullable
    public static Farmer getPlayer(@NotNull UUID uuid) {
        return players.stream().filter(fp -> fp.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    @Nullable
    public static Farmer getPlayer(@NotNull OfflinePlayer offlinePlayer) {
        return players.stream().filter(fp -> fp.getOfflinePlayer().equals((Object)offlinePlayer)).findFirst().orElse(null);
    }

    public static void load(@NotNull UUID uuid) {
        File file = new File(FarmQuest.getInstance().getDataFolder(), "players/" + String.valueOf(uuid) + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Quest quest = Quest.getQuest(config.getString("active_quest.quest", ""));
        Farm farm = Farm.getFarm(config.getString("active_quest.farm", ""));
        QuestProgress activeQuestProgress = null;
        if (quest != null && farm != null) {
            int progress = config.getInt("active_quest.progress", 0);
            long startTime = config.getLong("active_quest.start_time", 0L);
            activeQuestProgress = new QuestProgress(quest, farm, progress, startTime);
        }
        List completedQuests = config.getStringList("completed_quests");
        Farmer farmer = new Farmer(uuid, activeQuestProgress, completedQuests);
        farmer.register();
        farmer.continueActiveQuest();
    }

    @NotNull
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    @Generated
    public QuestProgress getActiveQuestProgress() {
        return this.activeQuestProgress;
    }

    @NotNull
    @Generated
    public Collection<String> getCompletedQuests() {
        return this.completedQuests;
    }

    @Nullable
    @Generated
    public KeyedBossBar getBossBar() {
        return this.bossBar;
    }

    @Generated
    public void setBossBar(@Nullable KeyedBossBar bossBar) {
        this.bossBar = bossBar;
    }

    @Generated
    public static Collection<Farmer> getPlayers() {
        return players;
    }
}

