/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model;

import java.util.function.Function;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.CaveVinesPlant;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.object.DMaterial;

public class BlockDataHolder {
    private Block block;
    private final BlockData formingBlockData;

    public BlockDataHolder(@NotNull Block block, @NotNull BlockData blockData) {
        Bisected bisected;
        this.block = block;
        if (blockData instanceof Bisected && (bisected = (Bisected)blockData).getHalf() == Bisected.Half.TOP) {
            this.block = this.block.getRelative(BlockFace.DOWN);
        }
        this.formingBlockData = BlockAdapter.findAdapterGetData(blockData.clone());
    }

    @Generated
    public Block getBlock() {
        return this.block;
    }

    @Generated
    public BlockData getFormingBlockData() {
        return this.formingBlockData;
    }

    private static enum BlockAdapter {
        CAVE_VINES_ADAPTER(oldData -> {
            if (!(oldData instanceof CaveVinesPlant)) {
                return oldData;
            }
            CaveVinesPlant caveVinesPlant = (CaveVinesPlant)oldData;
            BlockData newData = Material.CAVE_VINES.createBlockData();
            if (newData instanceof CaveVinesPlant) {
                CaveVinesPlant caveVinesPlant1 = (CaveVinesPlant)newData;
                caveVinesPlant1.setBerries(caveVinesPlant.isBerries());
            }
            if (newData instanceof Ageable) {
                Ageable ageable = (Ageable)newData;
                ageable.setAge(0);
            }
            return newData;
        }),
        KELP_ADAPTER(oldData -> {
            if (oldData.getMaterial() != Material.KELP_PLANT) {
                return oldData;
            }
            BlockData newData = Material.KELP.createBlockData();
            if (newData instanceof Ageable) {
                Ageable ageable = (Ageable)newData;
                ageable.setAge(0);
            }
            return newData;
        }),
        TORCHFLOWER_CROP_ADAPTER(oldData -> {
            if (oldData.getMaterial() != Material.TORCHFLOWER) {
                return oldData;
            }
            BlockData newData = Material.TORCHFLOWER_CROP.createBlockData();
            if (newData instanceof Ageable) {
                Ageable ageable = (Ageable)newData;
                ageable.setAge(0);
            }
            return newData;
        }),
        AGEABLE_ADAPTER(oldData -> {
            if (!(oldData instanceof Ageable)) {
                return oldData;
            }
            BlockData newData = oldData.clone();
            if (newData instanceof Ageable) {
                Ageable ageable = (Ageable)newData;
                ageable.setAge(0);
            }
            return newData;
        });

        private final Function<BlockData, BlockData> function;

        private BlockAdapter(Function<BlockData, BlockData> function) {
            this.function = function;
        }

        public BlockData getData(@NotNull BlockData oldData) {
            return this.function.apply(oldData);
        }

        public static BlockData findAdapterGetData(@NotNull BlockData blockData) {
            DMaterial dMaterial = DMaterial.getByName(blockData.getMaterial().toString());
            return switch (dMaterial) {
                case DMaterial.CAVE_VINES_PLANT -> CAVE_VINES_ADAPTER.getData(blockData);
                case DMaterial.KELP_PLANT -> KELP_ADAPTER.getData(blockData);
                case DMaterial.TORCHFLOWER -> TORCHFLOWER_CROP_ADAPTER.getData(blockData);
                default -> AGEABLE_ADAPTER.getData(blockData);
            };
        }
    }
}

