/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.guimanager.button.Button;
import org.nandayo.dapi.guimanager.menu.Menu;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.model.quest.QuestProperty;
import org.nandayo.farmquest.service.registry.GUIRegistry;
import org.nandayo.farmquest.util.FUtil;

public class QuestListMenu
extends Menu {
    @NotNull
    private final FarmQuest plugin;
    @NotNull
    private final Player player;
    private final int page;
    private final @NotNull Consumer<@Nullable Quest> consumer;
    @NotNull
    private final GUIRegistry guiRegistry;
    private final String menuNamespace = "menus.quest_list";
    private final List<Integer> availableSlots = Arrays.asList(FUtil.getIntegersBetween(0, 53, 45, 53).toArray(new Integer[0]));

    public QuestListMenu(@NotNull Player player, int page, @NotNull Consumer<@Nullable Quest> consumer) {
        this.plugin = FarmQuest.getInstance();
        this.player = player;
        this.page = page;
        this.consumer = consumer;
        this.guiRegistry = this.plugin.guiRegistry;
        this.open();
    }

    private void open() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.guiRegistry.getString("menus.quest_list.title"));
        int itemsPerPage = this.availableSlots.size();
        int questIndex = (this.page - 1) * itemsPerPage;
        List quests = (List)Quest.getRegisteredQuests();
        for (int i = 0; i < itemsPerPage && questIndex < quests.size(); ++questIndex, ++i) {
            final Quest quest = (Quest)quests.get(questIndex);
            final int slot = this.availableSlots.get(questIndex % itemsPerPage);
            this.addButton(new Button(){
                final String path = "quest";

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Set.of(Integer.valueOf(slot));
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(quest.getIcon()).name(QuestListMenu.this.guiRegistry.getString("menus.quest_list.quest.name").replace("{quest}", quest.getId())).lore(() -> {
                        ArrayList<String> lore = new ArrayList<String>();
                        for (String line : QuestListMenu.this.guiRegistry.getStringList("menus.quest_list.quest.lore")) {
                            if (line.contains("{property_state}") || line.contains("{property_name}")) {
                                for (QuestProperty.Property property : quest.getQuestProperty().values()) {
                                    lore.add(line.replace("{property_state}", property.isEnabled() ? "ENABLED" : "DISABLED").replace("{property_name}", property.getDisplayName()));
                                }
                                continue;
                            }
                            lore.add(line.replace("{quest}", quest.getId()).replace("{quest_name}", quest.getName()).replace("{quest_description}", quest.getDescription()));
                        }
                        return lore;
                    }).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    QuestListMenu.this.consumer.accept(quest);
                }
            });
        }
        final boolean prevPageAvailable = this.page > 1;
        this.addButton(new Button(){
            final String path = "previous";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(45));
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(QuestListMenu.this.guiRegistry.getString("menus.quest_list.previous.name")).lore(QuestListMenu.this.guiRegistry.getStringList("menus.quest_list.previous.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (prevPageAvailable) {
                    new QuestListMenu(player, QuestListMenu.this.page - 1, QuestListMenu.this.consumer);
                }
            }
        });
        final boolean nextPageAvailable = this.page < (quests.size() - 1) / itemsPerPage + 1;
        this.addButton(new Button(){
            final String path = "next";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(53));
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(QuestListMenu.this.guiRegistry.getString("menus.quest_list.next.name")).lore(QuestListMenu.this.guiRegistry.getStringList("menus.quest_list.next.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (nextPageAvailable) {
                    new QuestListMenu(player, QuestListMenu.this.page + 1, QuestListMenu.this.consumer);
                }
            }
        });
        this.displayTo(this.player);
    }

    @Override
    public <T extends Inventory> Consumer<T> onClose() {
        return inv -> this.consumer.accept(null);
    }
}

