/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.guimanager.button.Button;
import org.nandayo.dapi.guimanager.button.PatternButton;
import org.nandayo.dapi.guimanager.menu.Menu;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.menu.AnvilInput;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.model.quest.QuestProperty;
import org.nandayo.farmquest.model.quest.Reward;
import org.nandayo.farmquest.model.quest.WritableQuest;
import org.nandayo.farmquest.service.OneTimeConsumer;
import org.nandayo.farmquest.service.registry.GUIRegistry;

public class QuestCreatorMenu
extends Menu {
    @NotNull
    private static final List<String> anvilLore = List.of("{WHITE}Click to continue!");
    @NotNull
    private final FarmQuest plugin = FarmQuest.getInstance();
    @NotNull
    private final Player player;
    @NotNull
    private final WritableQuest writableQuest;
    @NotNull
    private final GUIRegistry guiRegistry;
    private final boolean questAlreadyExists;
    public String menuNamespace = "menus.quest_creator";
    private static final String[] glassPattern = new String[]{"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"};

    public QuestCreatorMenu(@NotNull Player player, @NotNull String id) {
        this.player = player;
        this.writableQuest = new WritableQuest(id);
        this.guiRegistry = FarmQuest.getInstance().guiRegistry;
        this.questAlreadyExists = Quest.getQuest(id) != null;
        this.open();
    }

    public QuestCreatorMenu(@NotNull Player player, @NotNull WritableQuest writableQuest) {
        this.player = player;
        this.writableQuest = writableQuest;
        this.guiRegistry = FarmQuest.getInstance().guiRegistry;
        this.questAlreadyExists = Quest.getQuest(writableQuest.getId()) != null;
        this.open();
    }

    private void open() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.guiRegistry.getString(this.menuNamespace + ".title").replace("{id}", this.writableQuest.getId()));
        this.addButton(new PatternButton(){

            @Override
            @NotNull
            public String[] getLayout() {
                return glassPattern;
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.ORANGE_STAINED_GLASS_PANE).name(" ").get();
            }
        });
        this.addButton(new Button(){
            final String path = "objective_type";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(20));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(QuestCreatorMenu.this.writableQuest.getType().getIcon()).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".objective_type.name").replace("{objective_type}", QuestCreatorMenu.this.writableQuest.getType().getDisplayName())).lore(() -> {
                    List<String> lore = QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".objective_type.lore");
                    lore.replaceAll(l -> l.replace("{objective_type}", QuestCreatorMenu.this.writableQuest.getType().getDisplayName()));
                    return lore;
                }).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new ObjectiveTypeSelector(QuestCreatorMenu.this.player, new OneTimeConsumer<Objective.ObjectiveType>(objType -> {
                    if (objType != null) {
                        QuestCreatorMenu.this.writableQuest.setType((Objective.ObjectiveType)((Object)objType));
                    }
                    new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                }));
            }
        });
        this.addButton(new Button(){
            final String path = "farm_block";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(21));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(QuestCreatorMenu.this.writableQuest.getIcon()).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".farm_block.name").replace("{farm_block}", QuestCreatorMenu.this.writableQuest.getFarmBlock().name()).replace("{target_amount}", String.valueOf(QuestCreatorMenu.this.writableQuest.getTargetAmount()))).lore(() -> {
                    List<String> lore = QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".farm_block.lore");
                    lore.replaceAll(l -> l.replace("{farm_block}", QuestCreatorMenu.this.writableQuest.getFarmBlock().name()).replace("{target_amount}", String.valueOf(QuestCreatorMenu.this.writableQuest.getTargetAmount())));
                    return lore;
                }).amount(QuestCreatorMenu.this.writableQuest.getTargetAmount()).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                if (clickType.isLeftClick()) {
                    new FarmBlockSelector(QuestCreatorMenu.this.player, new OneTimeConsumer<FarmBlock>(farmBlock -> {
                        if (farmBlock != null) {
                            QuestCreatorMenu.this.writableQuest.setFarmBlock((FarmBlock)((Object)farmBlock));
                        }
                        new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                    }));
                } else if (clickType == ClickType.RIGHT) {
                    new AnvilInput(QuestCreatorMenu.this.player, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".farm_block.anvil_title"), String.valueOf(QuestCreatorMenu.this.writableQuest.getTargetAmount()), anvilLore, new OneTimeConsumer<String>(text -> {
                        if (text != null) {
                            int amount = QuestCreatorMenu.this.writableQuest.getTargetAmount();
                            try {
                                amount = Integer.parseInt(text);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            QuestCreatorMenu.this.writableQuest.setTargetAmount(amount);
                        }
                        new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                    }));
                } else if (clickType == ClickType.SHIFT_RIGHT) {
                    QuestCreatorMenu.this.writableQuest.setIcon(null);
                    new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                }
            }
        });
        this.addButton(new Button(){
            final String path = "time_limit";

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(22));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".time_limit.name").replace("{time_limit}", String.valueOf(QuestCreatorMenu.this.writableQuest.getTimeLimit()))).lore(() -> {
                    List<String> lore = QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".time_limit.lore");
                    lore.replaceAll(l -> l.replace("{time_limit}", String.valueOf(QuestCreatorMenu.this.writableQuest.getTimeLimit())));
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilInput(QuestCreatorMenu.this.player, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".time_limit.anvil_title"), String.valueOf(QuestCreatorMenu.this.writableQuest.getTimeLimit()), anvilLore, new OneTimeConsumer<String>(text -> {
                    if (text != null) {
                        long timeLimit = QuestCreatorMenu.this.writableQuest.getTimeLimit();
                        try {
                            timeLimit = Long.parseLong(text);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        QuestCreatorMenu.this.writableQuest.setTimeLimit(timeLimit);
                    }
                    new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                }));
            }
        });
        this.addButton(new Button(){
            final String path = "rewards";

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(23));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.EMERALD).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".rewards.name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".rewards.lore")) {
                        if (line.contains("{reward_line}")) {
                            for (Reward.RewardType type : Reward.RewardType.values()) {
                                Reward reward = QuestCreatorMenu.this.writableQuest.getReward(type);
                                if (reward == null) continue;
                                for (String rewardLine : reward.getRun()) {
                                    lore.add(line.replace("{reward_line}", rewardLine));
                                }
                            }
                            continue;
                        }
                        lore.add(line);
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                if (clickType.isLeftClick()) {
                    Reward commandReward = QuestCreatorMenu.this.writableQuest.getRewardOrCreate(Reward.RewardType.COMMAND);
                    new RewardManager(QuestCreatorMenu.this.player, commandReward.getRun(), new OneTimeConsumer<List<String>>(run -> {
                        commandReward.setRun((List<String>)run);
                        new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                    }));
                } else if (clickType.isRightClick()) {
                    Reward toolReward = QuestCreatorMenu.this.writableQuest.getRewardOrCreate(Reward.RewardType.FARM_TOOL);
                    new RewardManager(QuestCreatorMenu.this.player, toolReward.getRun(), new OneTimeConsumer<List<String>>(run -> {
                        toolReward.setRun((List<String>)run);
                        new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                    }));
                }
            }
        });
        this.addButton(new Button(){
            final String path = "properties";

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(24));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                QuestProperty questProperty = QuestCreatorMenu.this.writableQuest.getQuestProperty();
                return ItemCreator.of(Material.ARMOR_STAND).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".properties.name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".properties.lore")) {
                        if (line.contains("{property_name}") || line.contains("{property_state}")) {
                            for (QuestProperty.Property property : questProperty.values()) {
                                lore.add(line.replace("{property_name}", property.getDisplayName()).replace("{property_state}", property.isEnabled() ? "ENABLED" : "DISABLED"));
                            }
                            continue;
                        }
                        lore.add(line);
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new PropertyEditor(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest.getQuestProperty(), () -> new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest));
            }
        });
        this.addButton(new Button(){
            final String path = "name";

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(30));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.NAME_TAG).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".name.name").replace("{name}", QuestCreatorMenu.this.writableQuest.getName())).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".name.lore")) {
                        lore.add(line.replace("{name}", QuestCreatorMenu.this.writableQuest.getName()));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilInput(QuestCreatorMenu.this.player, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".name.anvil_title"), QuestCreatorMenu.this.writableQuest.getName(), anvilLore, new OneTimeConsumer<String>(text -> {
                    if (text == null) {
                        return;
                    }
                    QuestCreatorMenu.this.writableQuest.setName((String)text);
                    new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                }));
            }
        });
        this.addButton(new Button(){
            final String path = "description";

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(32));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.OAK_SIGN).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".description.name").replace("{description}", QuestCreatorMenu.this.writableQuest.getDescription())).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".description.lore")) {
                        lore.add(line.replace("{description}", QuestCreatorMenu.this.writableQuest.getDescription()));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilInput(QuestCreatorMenu.this.player, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".description.anvil_title"), QuestCreatorMenu.this.writableQuest.getDescription(), anvilLore, new OneTimeConsumer<String>(text -> {
                    if (text == null) {
                        return;
                    }
                    QuestCreatorMenu.this.writableQuest.setDescription((String)text);
                    new QuestCreatorMenu(QuestCreatorMenu.this.player, QuestCreatorMenu.this.writableQuest);
                }));
            }
        });
        this.addButton(new Button(){
            final String path = "save";

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(53));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.ORANGE_DYE).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".save.name")).lore(QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".save.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                Quest quest;
                QuestCreatorMenu.this.player.closeInventory();
                Quest quest2 = quest = QuestCreatorMenu.this.questAlreadyExists ? QuestCreatorMenu.this.writableQuest.saveToQuest() : QuestCreatorMenu.this.writableQuest.createQuest();
                if (quest != null) {
                    quest.register();
                    Util.tell((CommandSender)QuestCreatorMenu.this.player, QuestCreatorMenu.this.plugin.languageUtil.getString("quest_created"));
                } else {
                    Util.tell((CommandSender)QuestCreatorMenu.this.player, QuestCreatorMenu.this.plugin.languageUtil.getString("quest_not_created"));
                }
            }
        });
        this.displayTo(this.player);
    }

    @Override
    public BiConsumer<PlayerInventory, Integer> onPlayerInventoryClick() {
        return (playerInv, slot) -> {
            ItemStack item = playerInv.getItem(slot.intValue());
            if (item == null) {
                return;
            }
            this.writableQuest.setIcon(item.getType());
            new QuestCreatorMenu(this.player, this.writableQuest);
        };
    }

    private class PropertyEditor
    extends Menu {
        @NotNull
        private final Player player;
        @NotNull
        private final QuestProperty questProperty;
        @NotNull
        private final Runnable runnable;

        public PropertyEditor(@NotNull Player player, @NotNull QuestProperty questProperty, Runnable runnable) {
            this.player = player;
            this.questProperty = questProperty;
            this.runnable = runnable;
            this.open();
        }

        private void open() {
            QuestCreatorMenu.this.menuNamespace = "menus.property_editor";
            this.createInventory(MenuType.CHEST_6_ROWS, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".title"));
            this.addButton(new PatternButton(){

                @Override
                @NotNull
                public String[] getLayout() {
                    return glassPattern;
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return ItemCreator.of(Material.ORANGE_STAINED_GLASS_PANE).name(" ").get();
                }
            });
            int starterSlot = 19;
            for (final QuestProperty.Property property : this.questProperty.values()) {
                final int slot = starterSlot += 2;
                this.addButton(new Button(){
                    final String path = "property";

                    @Override
                    @NotNull
                    protected Set<Integer> getSlots() {
                        return Set.of(Integer.valueOf(slot));
                    }

                    @Override
                    @Nullable
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.ARMOR_STAND).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".property.name").replace("{property_state}", property.isEnabled() ? "ENABLED" : "DISABLED").replace("{property_name}", property.getDisplayName())).lore(() -> {
                            List<String> lore = QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".property.lore");
                            lore.replaceAll(l -> l.replace("{property_state}", property.isEnabled() ? "ENABLED" : "DISABLED").replace("{property_name}", property.getDisplayName()));
                            return lore;
                        }).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        property.setEnabled(!property.isEnabled());
                        new PropertyEditor(PropertyEditor.this.player, PropertyEditor.this.questProperty, PropertyEditor.this.runnable);
                    }
                });
            }
            this.addButton(new Button(){
                final String path = "back";

                @Override
                @NotNull
                protected Set<Integer> getSlots() {
                    return Set.of(Integer.valueOf(53));
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return ItemCreator.of(Material.OAK_DOOR).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".back.name")).lore(QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".back.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    Bukkit.getScheduler().runTask((Plugin)FarmQuest.getInstance(), PropertyEditor.this.runnable);
                }
            });
            this.displayTo(this.player);
        }
    }

    private class RewardManager
    extends Menu {
        @NotNull
        private final Player player;
        @NotNull
        private final List<String> run;
        @NotNull
        private final OneTimeConsumer<List<String>> consumer;

        public RewardManager(@NotNull Player player, @NotNull List<String> currentRun, OneTimeConsumer<List<String>> consumer) {
            this.player = player;
            this.run = currentRun;
            this.consumer = consumer;
            this.open();
        }

        private void open() {
            QuestCreatorMenu.this.menuNamespace = "menus.reward_manager";
            this.createInventory(MenuType.CHEST_6_ROWS, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".title"));
            int i = 0;
            for (final String runLine : new ArrayList<String>(this.run)) {
                final int slot = i++;
                this.addButton(new Button(){
                    final String path = "reward_line";

                    @Override
                    @NotNull
                    protected Set<Integer> getSlots() {
                        return Set.of(Integer.valueOf(slot));
                    }

                    @Override
                    @Nullable
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.PAPER).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".reward_line.name").replace("{order}", String.valueOf(slot + 1))).lore(() -> {
                            ArrayList<String> lore = new ArrayList<String>();
                            for (String line : QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".reward_line.lore")) {
                                if (line.contains("{reward_line}")) {
                                    for (String rewardLine : RewardManager.this.run) {
                                        lore.add(line.replace("{reward_line}", rewardLine));
                                    }
                                    continue;
                                }
                                lore.add(line);
                            }
                            return lore;
                        }).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        if (clickType == ClickType.SHIFT_RIGHT) {
                            RewardManager.this.run.remove(runLine);
                            new RewardManager(RewardManager.this.player, RewardManager.this.run, RewardManager.this.consumer);
                        }
                    }
                });
            }
            final int addSlot = i;
            this.addButton(new Button(){
                final String path = "new";

                @Override
                @NotNull
                protected Set<Integer> getSlots() {
                    return Set.of(Integer.valueOf(addSlot));
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return ItemCreator.of(Material.LIME_DYE).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".new.name")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    new AnvilInput(RewardManager.this.player, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".new.anvil_title"), "", anvilLore, new OneTimeConsumer<String>(text -> {
                        if (text == null) {
                            return;
                        }
                        RewardManager.this.run.add((String)text);
                        new RewardManager(RewardManager.this.player, RewardManager.this.run, RewardManager.this.consumer);
                    }));
                }
            });
            this.addButton(new Button(){
                final String path = "back";

                @Override
                @NotNull
                protected Set<Integer> getSlots() {
                    return Set.of(Integer.valueOf(53));
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return ItemCreator.of(Material.OAK_DOOR).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".back.name")).lore(QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".back.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    RewardManager.this.consumer.acceptSync(RewardManager.this.run);
                }
            });
            this.displayTo(this.player);
        }
    }

    private class FarmBlockSelector
    extends Menu {
        @NotNull
        private final Player player;
        private final @NotNull OneTimeConsumer<@Nullable FarmBlock> consumer;

        public FarmBlockSelector(@NotNull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable Player player, OneTimeConsumer<FarmBlock> consumer) {
            this.player = player;
            this.consumer = consumer;
            this.open();
        }

        private void open() {
            QuestCreatorMenu.this.menuNamespace = "menus.farm_block_selector";
            this.createInventory(MenuType.CHEST_6_ROWS, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".title"));
            this.addButton(new PatternButton(){

                @Override
                @NotNull
                public String[] getLayout() {
                    return glassPattern;
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return ItemCreator.of(Material.ORANGE_STAINED_GLASS_PANE).name(" ").get();
                }
            });
            int i = 0;
            int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
            for (final FarmBlock farmBlock : FarmBlock.values()) {
                final int slot = slots[i++];
                this.addButton(new Button(){
                    final String path = "farm_block";

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Set.of(Integer.valueOf(slot));
                    }

                    @Override
                    @Nullable
                    public ItemStack getItem() {
                        return ItemCreator.of(farmBlock.getSeedMaterial()).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".farm_block.name").replace("{farm_block}", farmBlock.name())).lore(() -> {
                            ArrayList<String> lore = new ArrayList<String>();
                            for (String line : QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".farm_block.lore")) {
                                lore.add(line.replace("{farm_block}", farmBlock.name()));
                            }
                            return lore;
                        }).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        FarmBlockSelector.this.consumer.acceptSync(farmBlock);
                    }
                });
            }
            this.displayTo(this.player);
        }

        @Override
        public <T extends Inventory> Consumer<T> onClose() {
            return inv -> this.consumer.acceptSync(null);
        }
    }

    private class ObjectiveTypeSelector
    extends Menu {
        @NotNull
        private final Player player;
        private final @NotNull OneTimeConsumer< @Nullable Objective.ObjectiveType> consumer;

        public ObjectiveTypeSelector(@NotNull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable Player player, OneTimeConsumer<Objective.ObjectiveType> consumer) {
            this.player = player;
            this.consumer = consumer;
            this.open();
        }

        private void open() {
            QuestCreatorMenu.this.menuNamespace = "menus.objective_type_selector";
            this.createInventory(MenuType.CHEST_6_ROWS, QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".title"));
            this.addButton(new PatternButton(){

                @Override
                @NotNull
                public String[] getLayout() {
                    return glassPattern;
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return ItemCreator.of(Material.ORANGE_STAINED_GLASS_PANE).name(" ").get();
                }
            });
            int i = 0;
            int[] slots = new int[]{20, 31, 24};
            for (final Objective.ObjectiveType type : Objective.ObjectiveType.values()) {
                final int slot = slots[i++];
                this.addButton(new Button(){
                    final String path = "objective_type";

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Set.of(Integer.valueOf(slot));
                    }

                    @Override
                    @Nullable
                    public ItemStack getItem() {
                        return ItemCreator.of(type.getIcon()).name(QuestCreatorMenu.this.guiRegistry.getString(QuestCreatorMenu.this.menuNamespace + ".objective_type.name").replace("{objective_type}", type.getDisplayName())).lore(() -> {
                            ArrayList<String> lore = new ArrayList<String>();
                            for (String line : QuestCreatorMenu.this.guiRegistry.getStringList(QuestCreatorMenu.this.menuNamespace + ".objective_type.lore")) {
                                lore.add(line.replace("{objective_type}", type.getDisplayName()));
                            }
                            return lore;
                        }).hideFlag(ItemFlag.values()).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        ObjectiveTypeSelector.this.consumer.acceptSync(type);
                    }
                });
            }
            this.displayTo(this.player);
        }

        @Override
        public <T extends Inventory> Consumer<T> onClose() {
            return inv -> this.consumer.acceptSync(null);
        }
    }
}

