/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.guimanager.button.Button;
import org.nandayo.dapi.guimanager.menu.Menu;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.model.farm.Farm;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.service.registry.GUIRegistry;
import org.nandayo.farmquest.util.FUtil;

public class FarmerMenu
extends Menu {
    @NotNull
    private final FarmQuest plugin;
    @NotNull
    private final Player player;
    @NotNull
    private final Farm farm;
    @NotNull
    private final GUIRegistry guiRegistry;
    private final String menuNamespace = "menus.farmer_menu";

    public FarmerMenu(@NotNull FarmQuest plugin, @NotNull Player player, @NotNull Farm farm) {
        this.plugin = plugin;
        this.player = player;
        this.farm = farm;
        this.guiRegistry = plugin.guiRegistry;
        this.open();
    }

    private void open() {
        final Farmer farmer = Farmer.getPlayer((OfflinePlayer)this.player);
        if (farmer == null) {
            this.plugin.tell((CommandSender)this.player, this.plugin.languageUtil.getString("not_a_farmer_player"));
            return;
        }
        this.createInventory(MenuType.CHEST_1_ROW, this.guiRegistry.getString("menus.farmer_menu.title").replace("{farm}", this.farm.getId()));
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(3));
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.WRITABLE_BOOK).name(FarmerMenu.this.guiRegistry.getString("menus.farmer_menu.pickup.name")).lore(FarmerMenu.this.guiRegistry.getStringList("menus.farmer_menu.pickup.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new FarmerMenuQuestList(FarmerMenu.this.plugin, player, 1, FarmerMenu.this.farm, farmer);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(5));
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BARREL).name(FarmerMenu.this.guiRegistry.getString("menus.farmer_menu.delivery.name")).lore(FarmerMenu.this.guiRegistry.getStringList("menus.farmer_menu.delivery.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                player.performCommand("farmquest deliver " + FarmerMenu.this.farm.getId());
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(8));
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.REDSTONE).name(FarmerMenu.this.guiRegistry.getString("menus.farmer_menu.drop.name")).lore(FarmerMenu.this.guiRegistry.getStringList("menus.farmer_menu.drop.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (farmer.getActiveQuestProgress() == null) {
                    farmer.tell(FarmerMenu.this.plugin.languageUtil.getString("do_not_have_active_quest"));
                    return;
                }
                farmer.dropQuest(false);
                farmer.tell(FarmerMenu.this.plugin.languageUtil.getString("drop_quest"));
            }
        });
        this.displayTo(this.player);
    }

    private class FarmerMenuQuestList
    extends Menu {
        @NotNull
        private final FarmQuest plugin;
        @NotNull
        private final Player player;
        private final int page;
        @NotNull
        private final Farm farm;
        @NotNull
        private final Farmer farmer;
        private final List<Integer> availableSlots = Arrays.asList(FUtil.getIntegersBetween(0, 53, 45, 53).toArray(new Integer[0]));

        public FarmerMenuQuestList(@NotNull FarmQuest plugin, Player player, @NotNull int page, @NotNull Farm farm, Farmer farmer) {
            this.plugin = plugin;
            this.player = player;
            this.page = page;
            this.farm = farm;
            this.farmer = farmer;
            this.open();
        }

        private void open() {
            this.createInventory(MenuType.CHEST_6_ROWS, FarmerMenu.this.guiRegistry.getString("menus.farmer_menu.sub_quest_list.title").replace("{farm}", this.farm.getId()));
            int itemsPerPage = this.availableSlots.size();
            int questIndex = (this.page - 1) * itemsPerPage;
            List quests = (List)this.farm.getQuests();
            for (int i = 0; i < itemsPerPage && questIndex < quests.size(); ++questIndex, ++i) {
                final Quest quest = (Quest)quests.get(questIndex);
                final int slot = this.availableSlots.get(questIndex % itemsPerPage);
                this.addButton(new Button(){

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Set.of(Integer.valueOf(slot));
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(quest.getIcon()).name(FarmerMenu.this.guiRegistry.getString("menus.farmer_menu.sub_quest_list.quest.name").replace("{quest}", quest.getName())).lore(() -> {
                            List<String> rawLore = FarmerMenu.this.guiRegistry.getStringList("menus.farmer_menu.sub_quest_list.quest.lore");
                            ArrayList<String> lore = new ArrayList<String>();
                            for (String line : rawLore) {
                                lore.add(line.replace("{quest_description}", quest.getDescription()));
                            }
                            return lore;
                        }).get();
                    }

                    @Override
                    public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                        player.closeInventory();
                        FarmerMenuQuestList.this.farmer.pickupQuest(quest, FarmerMenuQuestList.this.farm);
                    }
                });
            }
            final boolean prevPageAvailable = this.page > 1;
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Set.of(Integer.valueOf(45));
                }

                @Override
                public ItemStack getItem() {
                    if (prevPageAvailable) {
                        return ItemCreator.of(Material.ARROW).name("&cPrevious Page").get();
                    }
                    return ItemCreator.of(Material.RED_DYE).name(" ").get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    if (prevPageAvailable) {
                        new FarmerMenuQuestList(FarmerMenuQuestList.this.plugin, player, FarmerMenuQuestList.this.page - 1, FarmerMenuQuestList.this.farm, FarmerMenuQuestList.this.farmer);
                    }
                }
            });
            final boolean nextPageAvailable = this.page < (quests.size() - 1) / itemsPerPage + 1;
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Set.of(Integer.valueOf(53));
                }

                @Override
                public ItemStack getItem() {
                    if (nextPageAvailable) {
                        return ItemCreator.of(Material.ARROW).name("&aNext Page").get();
                    }
                    return ItemCreator.of(Material.RED_DYE).name(" ").get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    if (nextPageAvailable) {
                        new FarmerMenuQuestList(FarmerMenuQuestList.this.plugin, player, FarmerMenuQuestList.this.page + 1, FarmerMenuQuestList.this.farm, FarmerMenuQuestList.this.farmer);
                    }
                }
            });
            this.displayTo(this.player);
        }
    }
}

