/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.guimanager.button.Button;
import org.nandayo.dapi.guimanager.menu.Menu;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.menu.QuestListMenu;
import org.nandayo.farmquest.model.farm.Farm;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.service.registry.GUIRegistry;

public class FarmEditorMenu
extends Menu {
    @NotNull
    private final FarmQuest plugin = FarmQuest.getInstance();
    @NotNull
    private final Player viewer;
    @NotNull
    private final Farm farm;
    @NotNull
    private final GUIRegistry guiRegistry;
    private final String menuNamespace = "menus.farm_editor";

    public FarmEditorMenu(@NotNull Player viewer, @NotNull Farm farm) {
        this.viewer = viewer;
        this.farm = farm;
        this.guiRegistry = this.plugin.guiRegistry;
        this.open();
    }

    private void open() {
        this.createInventory(MenuType.CHEST_1_ROW, this.guiRegistry.getString("menus.farm_editor.title").replace("{farm}", this.farm.getId()));
        this.addButton(new Button(){
            final String path = "region";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(0));
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.HAY_BLOCK).name(FarmEditorMenu.this.guiRegistry.getString("menus.farm_editor.region.name").replace("{region}", FarmEditorMenu.this.farm.getRegion().parseString())).lore(FarmEditorMenu.this.guiRegistry.getStringList("menus.farm_editor.region.lore").stream().map(l -> l.replace("{region}", FarmEditorMenu.this.farm.getRegion().parseString())).toList()).get();
            }
        });
        this.addButton(new Button(){
            final List<Quest> linkedQuests;
            {
                this.linkedQuests = FarmEditorMenu.this.farm.getQuests().stream().filter(Objects::nonNull).toList();
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(1));
            }

            @Override
            public ItemStack getItem() {
                String path = "linked_quests";
                return ItemCreator.of(Material.WRITABLE_BOOK).name(FarmEditorMenu.this.guiRegistry.getString("menus.farm_editor.linked_quests.name")).lore(() -> {
                    List<String> rawLore = FarmEditorMenu.this.guiRegistry.getStringList("menus.farm_editor.linked_quests.lore");
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : rawLore) {
                        if (line.contains("{quest.%n}")) {
                            for (Quest quest : this.linkedQuests) {
                                lore.add(line.replace("{quest.%n}", quest.getId()));
                            }
                            continue;
                        }
                        lore.add(line);
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (clickType == ClickType.LEFT) {
                    FarmEditorMenu.this.linkQuestViaMenu(FarmEditorMenu.this.farm, player);
                } else if (clickType == ClickType.RIGHT) {
                    FarmEditorMenu.this.unlinkQuestViaMenu(FarmEditorMenu.this.farm, player);
                }
            }
        });
        this.displayTo(this.viewer);
    }

    private void linkQuestViaMenu(@NotNull Farm farm, @NotNull Player player) {
        new QuestListMenu(player, 1, quest -> {
            if (quest == null) {
                return;
            }
            if (farm.linkQuest((Quest)quest)) {
                this.plugin.farmRegistry.save();
                this.plugin.tell((CommandSender)player, this.plugin.languageUtil.getString("quest_linked_to_farm").replace("{farm}", farm.getId()));
                player.playSound(player.getLocation(), Sound.BLOCK_CHAIN_PLACE, 1.0f, 1.0f);
            } else {
                this.plugin.tell((CommandSender)player, this.plugin.languageUtil.getString("quest_already_linked_to_farm").replace("{farm}", farm.getId()));
            }
            new FarmEditorMenu(player, farm);
        });
    }

    private void unlinkQuestViaMenu(@NotNull Farm farm, @NotNull Player player) {
        new QuestListMenu(player, 1, quest -> {
            if (quest == null) {
                return;
            }
            if (farm.unlinkQuest((Quest)quest)) {
                this.plugin.farmRegistry.save();
                this.plugin.tell((CommandSender)player, this.plugin.languageUtil.getString("quest_unlink_from_farm").replace("{farm}", farm.getId()));
                player.playSound(player.getLocation(), Sound.BLOCK_CHAIN_BREAK, 1.0f, 1.0f);
            } else {
                this.plugin.tell((CommandSender)player, this.plugin.languageUtil.getString("quest_already_not_linked_to_farm").replace("{farm}", farm.getId()));
            }
            new FarmEditorMenu(player, farm);
        });
    }
}

