/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.menu;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.button.Button;
import org.nandayo.dapi.guimanager.menu.AnvilMenu;
import org.nandayo.farmquest.service.OneTimeConsumer;

public class AnvilInput
extends AnvilMenu {
    @NotNull
    private final Player player;
    @NotNull
    private final String title;
    @NotNull
    private final String initialText;
    @NotNull
    private final List<String> lore;
    @NotNull
    private final OneTimeConsumer<String> textConsumer;

    public AnvilInput(@NotNull Player player, @NotNull String title, @NotNull String initialText, @NotNull List<String> lore, @NotNull OneTimeConsumer<String> textConsumer) {
        this.player = player;
        this.title = title;
        this.initialText = initialText.isEmpty() ? " " : initialText;
        this.lore = lore;
        this.textConsumer = textConsumer;
        this.open();
    }

    private void open() {
        this.createInventory(this.player, this.title);
        this.addButton(new Button(){

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(0));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.PAPER).name(AnvilInput.this.initialText).get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Set.of(Integer.valueOf(2));
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.NAME_TAG).name(AnvilInput.this.initialText).lore(AnvilInput.this.lore).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                AnvilInput.this.textConsumer.acceptSync(AnvilInput.this.getText());
            }
        });
        this.displayTo(this.player);
    }

    @Override
    public <T extends Inventory> Consumer<T> onClose() {
        return inv -> this.textConsumer.acceptSync(this.getText());
    }
}

