/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.listener;

import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.enumeration.Setting;
import org.nandayo.farmquest.enumeration.VerticalGrowthType;
import org.nandayo.farmquest.event.FarmBlockBreakEvent;
import org.nandayo.farmquest.event.FarmBlockPlaceEvent;
import org.nandayo.farmquest.event.QuestCompleteEvent;
import org.nandayo.farmquest.event.QuestProgressEvent;
import org.nandayo.farmquest.model.BlockDataHolder;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.QuestProgress;
import org.nandayo.farmquest.util.FUtil;
import org.nandayo.farmquest.util.MaterialUtil;

public class CustomListener
implements Listener {
    @EventHandler
    public void onFarmBlockBreak(FarmBlockBreakEvent event) {
        boolean isRoot;
        if (event.isCancelled()) {
            return;
        }
        Farmer farmer = event.getFarmer();
        if (farmer.getPlayer().isEmpty()) {
            return;
        }
        Player player = farmer.getPlayer().get();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Block block = event.getBlock();
        BlockData blockData = event.getBlockData();
        FarmBlock farmBlock = event.getFarmBlock();
        QuestProgress questProgress = event.getQuestProgress();
        int progress = 0;
        VerticalGrowthType growthType = VerticalGrowthType.get(blockData.getMaterial());
        if (growthType == null) {
            isRoot = true;
            if (FUtil.isReadyToHarvest(blockData)) {
                ++progress;
            }
        } else {
            BlockFace face = growthType.getBlockFace();
            isRoot = !farmBlock.equals(block.getRelative(face.getOppositeFace()).getType());
            Block blockRelative = block;
            while (farmBlock.equals(blockRelative.getType())) {
                if (FUtil.isReadyToHarvest(blockRelative.getBlockData())) {
                    ++progress;
                }
                blockRelative = blockRelative.getRelative(face);
            }
        }
        BlockDataHolder blockDataHolder = null;
        if (isRoot) {
            blockDataHolder = new BlockDataHolder(block, blockData);
        }
        if (progress > 0 && questProgress.getQuest().getType() == Objective.ObjectiveType.HARVEST) {
            int finalProgress = progress;
            Bukkit.getScheduler().runTask((Plugin)FarmQuest.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)new QuestProgressEvent(farmer, questProgress, finalProgress)));
        }
        if (Setting.AUTO_PLANT.isEnabled() && isRoot) {
            BlockDataHolder finalBdh = blockDataHolder;
            Bukkit.getScheduler().runTaskLater((Plugin)FarmQuest.getInstance(), () -> {
                Block bdhBlock = finalBdh.getBlock();
                if (!block.getType().isAir() && block.getType() != Material.WATER) {
                    return;
                }
                bdhBlock.setBlockData(finalBdh.getFormingBlockData());
            }, 120L);
        }
    }

    @EventHandler
    public void onFarmBlockPlace(FarmBlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Farmer farmer = event.getFarmer();
        Player player = farmer.getOfflinePlayer().getPlayer();
        if (player == null || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Block block = event.getBlock();
        BlockData blockData = event.getBlockData();
        QuestProgress questProgress = event.getQuestProgress();
        Bukkit.getScheduler().runTask((Plugin)FarmQuest.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)new QuestProgressEvent(farmer, questProgress, 1)));
        Material oldType = blockData.getMaterial();
        if (Setting.AUTO_REMOVE.isEnabled()) {
            Bukkit.getScheduler().runTaskLater((Plugin)FarmQuest.getInstance(), () -> {
                if (block.getType() != oldType) {
                    return;
                }
                block.setType(Material.AIR);
            }, 200L);
        }
    }

    @EventHandler
    public void onQuestProgress(QuestProgressEvent event) {
        Farmer farmer = event.getFarmer();
        QuestProgress questProgress = event.getQuestProgress();
        if (questProgress.plus(event.getProgress())) {
            Bukkit.getScheduler().runTask((Plugin)FarmQuest.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)new QuestCompleteEvent(farmer, event.getQuestProgress())));
        }
    }

    @EventHandler
    public void onQuestComplete(QuestCompleteEvent event) {
        Farmer farmer = event.getFarmer();
        farmer.dropQuest(true);
        QuestProgress questProgress = event.getQuestProgress();
        Player player = farmer.getOfflinePlayer().getPlayer();
        if (questProgress.getQuest().getType() == Objective.ObjectiveType.DELIVER && player != null) {
            MaterialUtil.removeMaterials(player, questProgress.getQuest().getFarmBlock().getCropMaterial(), questProgress.getQuest().getTargetAmount());
        }
        questProgress.getQuest().grantRewards(farmer);
        farmer.tell(FarmQuest.getInstance().languageUtil.getString("quest_complete").replace("{quest}", questProgress.getQuest().getName()));
    }
}

