/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.farmquest.command.CreateQuestCommand;
import org.nandayo.farmquest.command.CreateRegionCommand;
import org.nandayo.farmquest.command.DeleteRegionCommand;
import org.nandayo.farmquest.command.DeliverCommand;
import org.nandayo.farmquest.command.EditQuestCommand;
import org.nandayo.farmquest.command.FarmManagerCommand;
import org.nandayo.farmquest.command.FarmMarkerCommand;
import org.nandayo.farmquest.command.FarmerMenuCommand;
import org.nandayo.farmquest.command.ReloadCommand;
import org.nandayo.farmquest.command.RemoveCompletedCommand;
import org.nandayo.farmquest.command.ResizeRegionCommand;
import org.nandayo.farmquest.model.farm.Farm;
import org.nandayo.farmquest.model.quest.Quest;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("farmer")) {
                return new FarmerMenuCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("deliver")) {
                return new DeliverCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("farmmarker")) {
                return new FarmMarkerCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("createregion")) {
                return new CreateRegionCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("resizeregion")) {
                return new ResizeRegionCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("deleteregion")) {
                return new DeleteRegionCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("createquest")) {
                return new CreateQuestCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("editquest")) {
                return new EditQuestCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("reload")) {
                return new ReloadCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("farmmanager")) {
                return new FarmManagerCommand().onSubCommand(sender, s, args);
            }
            if (args[0].equalsIgnoreCase("removecompleted")) {
                return new RemoveCompletedCommand().onSubCommand(sender, s, args);
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(List.of("deliver", "farmer"));
            for (String arg : Arrays.asList("farmmarker", "createregion", "resizeregion", "deleteregion", "createquest", "editquest", "reload", "farmmanager", "removecompleted")) {
                if (!sender.hasPermission("farmquest." + arg)) continue;
                completions.add(arg);
            }
            return completions;
        }
        if (args.length == 2 && Arrays.asList("farmer", "deliver", "farmmanager", "resizeregion", "deleteregion").contains(args[0])) {
            return Farm.getRegisteredFarms().stream().filter(Objects::nonNull).map(Farm::getId).toList();
        }
        if (args.length == 2 && Arrays.asList("removecompleted", "editquest").contains(args[0])) {
            return Quest.getRegisteredQuests().stream().filter(Objects::nonNull).map(Quest::getId).toList();
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("removecompleted")) {
            return null;
        }
        return List.of();
    }
}

