/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.command;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.command.SubCommand;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.menu.FarmEditorMenu;
import org.nandayo.farmquest.model.farm.Farm;

public class FarmManagerCommand
extends SubCommand {
    @Override
    public boolean onSubCommand(@NotNull CommandSender sender, @NotNull String s, String[] args) {
        FarmQuest plugin = FarmQuest.getInstance();
        if (!sender.hasPermission("farmquest.command.farmmanager")) {
            plugin.tell(sender, plugin.languageUtil.getString("command.no.perm"));
            return true;
        }
        if (!(sender instanceof Player)) {
            plugin.tell(sender, plugin.languageUtil.getString("command.only_players"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.sendMissingArgsMsg(sender, s, args, "<farmId>");
            return true;
        }
        if (Farm.getRegisteredFarms().isEmpty()) {
            plugin.tell((CommandSender)player, plugin.languageUtil.getString("farms_empty"));
            return true;
        }
        Farm farm = Farm.getFarm(args[1]);
        if (farm == null) {
            plugin.tell((CommandSender)player, plugin.languageUtil.getString("command.farm_not_found").replace("{farm}", args[1]));
            return true;
        }
        new FarmEditorMenu(player, farm);
        return true;
    }
}

