/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.model.Point;
import org.nandayo.farmquest.bstats.bukkit.Metrics;
import org.nandayo.farmquest.command.MainCommand;
import org.nandayo.farmquest.listener.BukkitListener;
import org.nandayo.farmquest.listener.CustomListener;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.service.BossBarManager;
import org.nandayo.farmquest.service.registry.ConfigRegistry;
import org.nandayo.farmquest.service.registry.FarmRegistry;
import org.nandayo.farmquest.service.registry.GUIRegistry;
import org.nandayo.farmquest.service.registry.QuestRegistry;
import org.nandayo.farmquest.util.LanguageUtil;
import org.nandayo.farmquest.util.UpdateChecker;
import org.nandayo.farmquest.util.Wrapper;

public final class FarmQuest
extends JavaPlugin {
    public final ItemStack FARM_MARKER = ItemCreator.of(Material.GOLDEN_AXE).name("&6Farm Marker").get();
    public final ItemStack FARM_DETECTOR = ItemCreator.of(Material.RABBIT_HIDE).get();
    public final HashMap<Player, Point[]> playerMarkers = new HashMap();
    private static FarmQuest instance;
    public BossBarManager bossBarManager;
    public QuestRegistry questRegistry;
    public FarmRegistry farmRegistry;
    public ConfigRegistry configRegistry;
    public GUIRegistry guiRegistry;
    public Wrapper wrapper;
    public LanguageUtil languageUtil;

    public void onEnable() {
        instance = this;
        Objects.requireNonNull(this.getCommand("farmquest")).setExecutor((CommandExecutor)new MainCommand());
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CustomListener(), (Plugin)this);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.setupDAPI();
        this.wrapper = new Wrapper(this);
        this.doRegistry();
        this.bossBarManager = new BossBarManager(this);
        this.bossBarManager.start();
        new Metrics((Plugin)this, 25233);
        new UpdateChecker(this, 124581).inform();
    }

    public void onDisable() {
        this.closeRegistry(false);
        if (this.bossBarManager != null) {
            this.bossBarManager.stop();
        }
        instance = null;
    }

    private void setupDAPI() {
        DAPI.registerMenuListener();
        Util.PREFIX = "&8[<#008387>FarmQuest&8]&7 ";
        HexUtil.placeholders = new HashMap<String, String>(){
            {
                this.put("{TITLE}", "<#008387>");
                this.put("{STAR}", "<#145f66>");
                this.put("{WHITE}", "<#ecfdff>");
                this.put("{WARN}", "<#e56666>");
                this.put("{SUCCESS}", "<#bfe769>");
            }
        };
        DAPI.setMissingArgsMsg("{WARN}Usage: /{command} {current_args} {options}");
    }

    private void doRegistry() {
        this.questRegistry = new QuestRegistry(this);
        this.questRegistry.load();
        this.farmRegistry = new FarmRegistry(this);
        this.farmRegistry.load();
        this.configRegistry = new ConfigRegistry(this);
        this.configRegistry.load();
        this.guiRegistry = new GUIRegistry(this);
        this.guiRegistry.load();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Farmer.load(player.getUniqueId());
        }
        this.languageUtil = new LanguageUtil(this, this.configRegistry.getConfig().getString("lang_file", "en_US"));
    }

    public void closeRegistry(boolean reload) {
        for (Farmer farmer : new ArrayList<Farmer>(Farmer.getPlayers())) {
            farmer.save();
        }
        this.farmRegistry.save();
        this.questRegistry.save();
        if (reload) {
            this.doRegistry();
        }
    }

    public void tell(@NotNull CommandSender receiver, String ... message) {
        for (String m : message) {
            receiver.sendMessage(HexUtil.parse(Util.PREFIX + m));
        }
    }

    public String formatTime(int time) {
        int sec = time;
        int min = sec / 60;
        int hour = min / 60;
        String str = String.format("%02d", hour %= 24) + ":" + String.format("%02d", min %= 60) + ":" + String.format("%02d", sec %= 60);
        return str.trim();
    }

    @Generated
    public static FarmQuest getInstance() {
        return instance;
    }
}

