/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.nms;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum NMSVersion {
    V1_16_R1(161),
    V1_16_R2(162, 163),
    V1_16_R3(164, 165),
    V1_17_R1(170),
    V1_17_1_R1(171),
    V1_18_R1(180, 181),
    V1_18_R2(182),
    V1_19_0_R1(190),
    V1_19_R1(191, 192),
    V1_19_R2(193),
    V1_19_R3(194),
    V1_20_R1(200, 201),
    V1_20_R2(202),
    V1_20_R3(203, 204),
    V1_20_R4(205, 206),
    V1_21_R1(210, 211),
    V1_21_R2(212, 213),
    V1_21_R3(214),
    V1_21_R4(215),
    V1_21_R5(216, 217);

    private final int[] minecraftVersions;
    @NotNull
    private static final Map<Integer, NMSVersion> VERSION_MAP;

    private NMSVersion(int ... minecraftVersions) {
        this.minecraftVersions = minecraftVersions;
    }

    public String removeV() {
        return this.name().replace("V", "");
    }

    public static NMSVersion findVersion(int minecraftVersion) {
        return VERSION_MAP.getOrDefault(minecraftVersion, V1_21_R5);
    }

    static {
        VERSION_MAP = new HashMap<Integer, NMSVersion>();
        for (NMSVersion version : NMSVersion.values()) {
            for (int i : version.minecraftVersions) {
                VERSION_MAP.put(i, version);
            }
        }
    }
}

