/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.message;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.message.ChannelBossBarMessage;
import org.nandayo.dapi.message.ChannelMessage;
import org.nandayo.dapi.message.ChannelTitleMessage;

public abstract class ChannelType {
    public static final ChannelType CHAT = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            receiver.sendMessage(HexUtil.parse(message.getMessage()));
        }
    };
    public static final ChannelType ACTION_BAR = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ((Player)receiver).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)HexUtil.parse(message.getMessage())));
        }
    };
    public static final ChannelType TITLE = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ChannelTitleMessage titleMessage = message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message);
            ((Player)receiver).sendTitle(HexUtil.parse(message.getMessage()), "", titleMessage.getFadeInTicks(), titleMessage.getStayTicks(), titleMessage.getFadeOutTicks());
        }
    };
    public static final ChannelType SUBTITLE = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ChannelTitleMessage titleMessage = message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message);
            ((Player)receiver).sendTitle(HexUtil.parse(message.getMessage()), "", titleMessage.getFadeInTicks(), titleMessage.getStayTicks(), titleMessage.getFadeOutTicks());
        }
    };
    public static final ChannelType TITLE_AND_SUBTITLE = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ChannelTitleMessage titleMessage = message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message);
            ((Player)receiver).sendTitle(HexUtil.parse(message.getMessage()), HexUtil.parse(titleMessage.getSecondaryMessage()), titleMessage.getFadeInTicks(), titleMessage.getStayTicks(), titleMessage.getFadeOutTicks());
        }
    };
    public static final ChannelType BOSS_BAR = new ChannelType(){

        @Override
        public <T extends ChannelMessage> void send(@NotNull CommandSender receiver, @NotNull T message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            ChannelBossBarMessage bossBarMessage = message instanceof ChannelBossBarMessage ? (ChannelBossBarMessage)message : ChannelBossBarMessage.fromParent(message);
            Player player = (Player)receiver;
            NamespacedKey randomKey = new NamespacedKey("dapi", "bossbar_message_" + Util.generateRandomString(8));
            KeyedBossBar bossBar = Bukkit.createBossBar((NamespacedKey)randomKey, (String)HexUtil.parse(message.getMessage()), (BarColor)bossBarMessage.getColor(), (BarStyle)bossBarMessage.getStyle(), (BarFlag[])bossBarMessage.getFlags());
            bossBar.setProgress(bossBarMessage.getProgress());
            bossBar.addPlayer(player);
            Bukkit.getScheduler().runTaskLater(DAPI.getPlugin(), () -> {
                bossBar.removePlayer((Player)receiver);
                Bukkit.removeBossBar((NamespacedKey)bossBar.getKey());
            }, (long)bossBarMessage.getStayTicks());
        }
    };

    private ChannelType() {
    }

    public abstract <T extends ChannelMessage> void send(@NotNull CommandSender var1, @NotNull T var2);

    public final void send(@NotNull CommandSender receiver, @NotNull String message) {
        this.send(receiver, new ChannelMessage(message));
    }

    public final <T extends ChannelMessage> void sendWithPrefix(@NotNull CommandSender receiver, @NotNull T message) {
        ChannelMessage prefixedMessage = message.clone();
        prefixedMessage.insertPrefix();
        this.send(receiver, prefixedMessage);
    }

    public final void sendWithPrefix(@NotNull CommandSender receiver, @NotNull String message) {
        this.sendWithPrefix(receiver, new ChannelMessage(message));
    }

    public final <T extends ChannelMessage> void sendAll(@NotNull T message, boolean includeConsole) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.send((CommandSender)player, message);
        }
        if (includeConsole) {
            this.send((CommandSender)Bukkit.getConsoleSender(), message);
        }
    }

    public final void sendAll(@NotNull String message, boolean includeConsole) {
        this.sendAll(new ChannelMessage(message), includeConsole);
    }

    public final <T extends ChannelMessage> void sendAllWithPrefix(@NotNull T message, boolean includeConsole) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendWithPrefix((CommandSender)player, message);
        }
        if (includeConsole) {
            this.sendWithPrefix((CommandSender)Bukkit.getConsoleSender(), message);
        }
    }

    public final void sendAllWithPrefix(@NotNull String message, boolean includeConsole) {
        this.sendAllWithPrefix(new ChannelMessage(message), includeConsole);
    }
}

