/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.message;

import lombok.Generated;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.message.ChannelMessage;

public class ChannelBossBarMessage
extends ChannelMessage
implements Cloneable {
    private int stayTicks = 60;
    @NotNull
    private BarColor color = BarColor.BLUE;
    @NotNull
    private BarStyle style = BarStyle.SOLID;
    @NotNull
    private BarFlag[] flags = new BarFlag[0];
    private double progress = 1.0;

    public ChannelBossBarMessage(@NotNull String message, int stayTicks, double progress, @NotNull BarColor color, @NotNull BarStyle style, BarFlag ... flags) {
        super(message);
        this.stayTicks = Math.max(1, stayTicks);
        this.progress(progress);
        this.color = color;
        this.style = style;
        this.flags = flags;
    }

    public ChannelBossBarMessage(@NotNull String message, int stayTicks, double progress) {
        super(message);
        this.stayTicks = Math.max(1, stayTicks);
        this.progress(progress);
    }

    public ChannelBossBarMessage(@NotNull String message) {
        super(message);
    }

    public void progress(double progress) {
        this.progress = Math.max(0.0, Math.min(1.0, progress));
    }

    public static ChannelBossBarMessage fromParent(@NotNull ChannelMessage message) {
        return new ChannelBossBarMessage(message.getMessage());
    }

    @Override
    public ChannelBossBarMessage clone() {
        return (ChannelBossBarMessage)super.clone();
    }

    @Generated
    public int getStayTicks() {
        return this.stayTicks;
    }

    @NotNull
    @Generated
    public BarColor getColor() {
        return this.color;
    }

    @NotNull
    @Generated
    public BarStyle getStyle() {
        return this.style;
    }

    @NotNull
    @Generated
    public BarFlag[] getFlags() {
        return this.flags;
    }

    @Generated
    public double getProgress() {
        return this.progress;
    }
}

