/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.guimanager;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.MetadataValue;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.guimanager.button.AbstractButton;
import org.nandayo.dapi.guimanager.menu.AbstractMenu;

public class MenuListener
implements Listener {
    @NotNull
    private static final HashMap<UUID, Long> LAST_SHIFT_CLICK = new HashMap();

    @EventHandler
    public void onGUIClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (p.hasMetadata(DAPI.GUI_METADATA_KEY)) {
            AbstractMenu menu = (AbstractMenu)((MetadataValue)p.getMetadata(DAPI.GUI_METADATA_KEY).get(0)).value();
            if (menu == null) {
                return;
            }
            e.setCancelled(!menu.isEmptySlotsModifiable());
            Long lastClick = LAST_SHIFT_CLICK.get(p.getUniqueId());
            long now = System.currentTimeMillis();
            if (e.getClick().isShiftClick() && lastClick != null && now - lastClick < 250L) {
                return;
            }
            LAST_SHIFT_CLICK.put(p.getUniqueId(), now);
            boolean clickedOnPlayerInventory = Objects.equals(e.getClickedInventory(), p.getInventory());
            if (clickedOnPlayerInventory) {
                menu.onPlayerInventoryClick().accept(p.getInventory(), e.getSlot());
                return;
            }
            AbstractButton abstractButton = menu.getButton(e.getSlot());
            if (abstractButton != null) {
                e.setCancelled(!abstractButton.isModifiable());
                Bukkit.getScheduler().runTask(DAPI.getPlugin(), () -> abstractButton.onClick(p, e.getClick()));
            }
        }
    }

    @EventHandler
    public void onGUIDrag(InventoryDragEvent e) {
        AbstractMenu menu;
        Player p = (Player)e.getWhoClicked();
        if (p.hasMetadata(DAPI.GUI_METADATA_KEY) && (menu = (AbstractMenu)((MetadataValue)p.getMetadata(DAPI.GUI_METADATA_KEY).get(0)).value()) != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onGUIClose(InventoryCloseEvent e) {
        Player p = (Player)e.getPlayer();
        if (p.hasMetadata(DAPI.GUI_METADATA_KEY)) {
            AbstractMenu menu = (AbstractMenu)((MetadataValue)p.getMetadata(DAPI.GUI_METADATA_KEY).get(0)).value();
            if (menu != null) {
                menu.onClose().accept(menu.getInventory());
            }
            p.removeMetadata(DAPI.GUI_METADATA_KEY, DAPI.getPlugin());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        LAST_SHIFT_CLICK.remove(e.getPlayer().getUniqueId());
        Player p = e.getPlayer();
        if (p.hasMetadata(DAPI.GUI_METADATA_KEY)) {
            AbstractMenu menu = (AbstractMenu)((MetadataValue)p.getMetadata(DAPI.GUI_METADATA_KEY).get(0)).value();
            if (menu != null) {
                menu.onClose().accept(menu.getInventory());
            }
            p.removeMetadata(DAPI.GUI_METADATA_KEY, DAPI.getPlugin());
        }
    }
}

