/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.DAPIException;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.guimanager.MenuListener;
import org.nandayo.farmquest.bstats.bukkit.Metrics;
import org.nandayo.farmquest.bstats.charts.SimplePie;

public final class DAPI {
    public static final String VERSION = "1.2.6";
    public static final String GUI_METADATA_KEY = "DAPI_GUI_" + Util.generateRandomLowerCaseString(8);
    private static Plugin plugin;
    private static boolean metricsRegistered;
    @Deprecated(since="1.2.5", forRemoval=true)
    @NotNull
    public static String missingArgsMsg;

    private DAPI() {
    }

    public static void registerMenuListener() {
        Bukkit.getPluginManager().registerEvents((Listener)new MenuListener(), DAPI.getPlugin());
    }

    @NotNull
    public static Plugin getPlugin() {
        if (plugin != null) {
            return plugin;
        }
        String pluginName = DAPI.forcePluginName();
        Plugin foundPlugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (foundPlugin == null) {
            throw new DAPIException("Plugin not found with name '" + pluginName + "'!");
        }
        plugin = foundPlugin;
        DAPI.registerMetrics();
        return plugin;
    }

    @NotNull
    private static String forcePluginName() {
        String pluginName = DAPI.findPluginName();
        if (pluginName != null) {
            return pluginName;
        }
        throw new DAPIException("Plugin name not found! To developer who uses DAPI, please check your plugin file (either 'plugin.yml' or 'paper-plugin.yml') and ensure it has 'name' key there.");
    }

    @Nullable
    private static String findPluginName() {
        ClassLoader loader = DAPI.class.getClassLoader();
        for (String pluginFile : List.of("plugin.yml", "paper-plugin.yml")) {
            try {
                InputStream stream = loader.getResourceAsStream(pluginFile);
                if (stream == null) continue;
                InputStreamReader reader = new InputStreamReader(stream);
                YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
                return config.getString("name");
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static void registerMetrics() {
        if (metricsRegistered) {
            return;
        }
        metricsRegistered = true;
        Util.log("[DAPI] Registering metrics for DAPI using plugin '" + plugin.getName() + "'.");
        Metrics metrics = new Metrics(plugin, 24974);
        metrics.addCustomChart(new SimplePie("dapi_version", () -> VERSION));
    }

    @Deprecated
    @NotNull
    @Generated
    public static String getMissingArgsMsg() {
        return missingArgsMsg;
    }

    @Deprecated
    @Generated
    public static void setMissingArgsMsg(@NotNull String missingArgsMsg) {
        if (missingArgsMsg == null) {
            throw new NullPointerException("missingArgsMsg is marked non-null but is null");
        }
        DAPI.missingArgsMsg = missingArgsMsg;
    }

    static {
        metricsRegistered = false;
        missingArgsMsg = "";
    }
}

