/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.util;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MaterialUtil {
    public static boolean hasSpace(@NotNull Player player, @NotNull ItemStack itemStack) {
        int space = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null) {
                space += itemStack.getMaxStackSize();
            } else if (item.isSimilar(itemStack)) {
                space += itemStack.getMaxStackSize() - item.getAmount();
            }
            if (space < itemStack.getAmount()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMaterials(@NotNull Player player, @NotNull Material material, int amount) {
        int remaining = amount;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || (remaining -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public static void removeMaterials(@NotNull Player player, @NotNull Material material, int amount) {
        int remaining = Math.max(0, amount);
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= remaining) {
                remaining -= itemAmount;
                item.setAmount(0);
                continue;
            }
            item.setAmount(itemAmount - remaining);
            break;
        }
    }

    public static void giveMaterials(@NotNull Player player, @NotNull Material material, int amount) {
        int maxStackSize = material.getMaxStackSize();
        while (amount > 0) {
            int stackSize = Math.min(amount, maxStackSize);
            amount -= stackSize;
            player.getInventory().addItem(new ItemStack[]{new ItemStack(material, stackSize)});
        }
    }
}

