/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.util;

import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.CaveVines;
import org.bukkit.block.data.type.CaveVinesPlant;
import org.jetbrains.annotations.NotNull;
import org.nandayo.farmquest.enumeration.FarmBlock;

public class FUtil {
    public static boolean isReadyToHarvest(@NotNull BlockData blockData) {
        FarmBlock farmBlock = FarmBlock.get(blockData.getMaterial());
        if (farmBlock == null) {
            return false;
        }
        switch (farmBlock.getCropMaterial()) {
            case KELP: 
            case CACTUS: 
            case SUGAR_CANE: 
            case BAMBOO: {
                return true;
            }
        }
        if (blockData instanceof CaveVines) {
            CaveVines caveVines = (CaveVines)blockData;
            return caveVines.isBerries();
        }
        if (blockData instanceof CaveVinesPlant) {
            CaveVinesPlant caveVinesPlant = (CaveVinesPlant)blockData;
            return caveVinesPlant.isBerries();
        }
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() >= ageable.getMaximumAge();
        }
        return true;
    }
}

