/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.service.registry;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.model.quest.Reward;
import org.nandayo.farmquest.service.registry.Registry;

public class QuestRegistry
extends Registry {
    public QuestRegistry(@NotNull FarmQuest plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getFilePath() {
        return "database/quests.yml";
    }

    @Override
    public void load() {
        Quest.getRegisteredQuests().clear();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.getFile());
        ConfigurationSection quests = config.getConfigurationSection("quests");
        if (quests == null) {
            return;
        }
        for (String id : quests.getKeys(false)) {
            String name = quests.getString(id + ".name", "Unknown");
            String description = quests.getString(id + ".description", "Unknown");
            Objective.ObjectiveType type = Objective.ObjectiveType.get(quests.getString(id + ".objective.type", ""));
            FarmBlock farmBlock = FarmBlock.get(quests.getString(id + ".objective.farm_block", ""));
            int targetAmount = quests.getInt(id + ".objective.target_amount", 0);
            long timeLimit = quests.getLong(id + ".objective.time_limit", 0L);
            if (type == null) {
                Util.log("{WARN}ObjectiveType for Quest '" + id + "' is null.");
                continue;
            }
            if (farmBlock == null) {
                Util.log("{WARN}FarmBlock for Quest '" + id + "' is null.");
                continue;
            }
            ArrayList<Reward> rewards = new ArrayList<Reward>();
            ConfigurationSection rewardSection = quests.getConfigurationSection(id + ".rewards");
            if (rewardSection != null) {
                for (String rewardKey : rewardSection.getKeys(false)) {
                    Reward.RewardType rewardType = Reward.RewardType.get(rewardKey);
                    if (rewardType == null) {
                        Util.log("{WARN}RewardType for Quest '" + id + "' is null.");
                        continue;
                    }
                    List run = rewardSection.getStringList(rewardKey);
                    rewards.add(new Reward(rewardType, run));
                }
            }
            new Quest(id, name, description, type, farmBlock, targetAmount, timeLimit, rewards).register();
        }
        Util.log("Loaded " + Quest.getRegisteredQuests().size() + " quests.");
    }

    @Override
    public void save() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.getFile());
        config.set("quests", null);
        for (Quest quest : Quest.getRegisteredQuests()) {
            String namespace = "quests." + quest.getId();
            config.set(namespace + ".name", (Object)quest.getName());
            config.set(namespace + ".description", (Object)quest.getDescription());
            config.set(namespace + ".objective.type", (Object)quest.getType().toString());
            config.set(namespace + ".objective.farm_block", (Object)quest.getFarmBlock().toString());
            config.set(namespace + ".objective.target_amount", (Object)quest.getTargetAmount());
            config.set(namespace + ".objective.time_limit", (Object)quest.getTimeLimit());
        }
        try {
            config.save(this.getFile());
        }
        catch (IOException e) {
            Util.log("{WARN}Couldn't save Quests configuration.");
            e.printStackTrace();
        }
    }
}

