/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.service;

import java.time.Instant;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.HexUtil;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.model.quest.Quest;
import org.nandayo.farmquest.model.quest.QuestProgress;

public class BossBarManager {
    private final FarmQuest plugin;
    private BukkitRunnable runnable;

    public BossBarManager(@NotNull FarmQuest plugin) {
        this.plugin = plugin;
    }

    public void start() {
        if (this.runnable != null) {
            return;
        }
        this.runnable = new BukkitRunnable(){

            public void run() {
                long currentSeconds = Instant.now().getEpochSecond();
                for (Farmer farmer : Farmer.getPlayers()) {
                    Player player = farmer.getOfflinePlayer().getPlayer();
                    if (player == null) continue;
                    QuestProgress questProgress = farmer.getActiveQuestProgress();
                    KeyedBossBar bossBar = farmer.getBossBar();
                    if (questProgress == null) {
                        if (bossBar == null) continue;
                        bossBar.removePlayer(player);
                        Bukkit.removeBossBar((NamespacedKey)bossBar.getKey());
                        farmer.setBossBar(null);
                        continue;
                    }
                    if (bossBar == null) {
                        bossBar = farmer.getBossBarOrCreate();
                    }
                    Quest quest = questProgress.getQuest();
                    int remained = (int)(quest.getTimeLimit() - (currentSeconds - questProgress.getStartTime()));
                    String title = HexUtil.parse(BossBarManager.this.plugin.languageUtil.getString("quest_progress_bar").replace("{quest}", quest.getName()).replace("{progress}", String.valueOf(questProgress.getProgress())).replace("{target}", String.valueOf(quest.getTargetAmount())).replace("{remained}", FarmQuest.getInstance().formatTime(remained)));
                    bossBar.setTitle(title);
                }
            }
        };
        this.runnable.runTaskTimer((Plugin)this.plugin, 20L, 60L);
    }

    public void stop() {
        if (this.runnable == null) {
            return;
        }
        this.runnable.cancel();
        this.runnable = null;
    }
}

