/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.quest;

import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.model.farm.FarmTool;

public class Reward {
    private final RewardType type;
    private final List<String> run;

    public Reward(@NotNull RewardType type, @NotNull List<String> run) {
        this.type = type;
        this.run = run;
    }

    public void grant(@NotNull Farmer farmer) {
        Player player = farmer.getOfflinePlayer().getPlayer();
        if (player == null) {
            return;
        }
        switch (this.type.ordinal()) {
            case 0: {
                for (String cmd : this.run) {
                    String fixedCmd = cmd.replace("%player_name%", player.getName()).trim();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)fixedCmd);
                }
                break;
            }
            case 1: {
                for (String farmToolId : this.run) {
                    FarmTool tool = FarmTool.getTool(farmToolId);
                    if (tool == null) {
                        Util.log(FarmQuest.getInstance().languageUtil.getString("tool_not_found").replace("{tool}", farmToolId));
                        continue;
                    }
                    player.getInventory().addItem(new ItemStack[]{tool.getItem()});
                    farmer.tell(FarmQuest.getInstance().languageUtil.getString("win_farm_tool"));
                }
                break;
            }
        }
    }

    @Generated
    public RewardType getType() {
        return this.type;
    }

    @Generated
    public List<String> getRun() {
        return this.run;
    }

    public static enum RewardType {
        COMMAND,
        FARM_TOOL;


        public static RewardType get(@NotNull String name) {
            try {
                return RewardType.valueOf(name.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

