/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.quest;

import java.time.Instant;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.model.farm.Farm;
import org.nandayo.farmquest.model.quest.Quest;

public class QuestProgress {
    private final Quest quest;
    private final Farm farm;
    private int progress;
    private final long startTime;
    private BukkitRunnable tickingTask = null;

    public QuestProgress(@NotNull Quest quest, @NotNull Farm farm, int progress, long startTime) {
        this.quest = quest;
        this.farm = farm;
        this.progress = progress;
        this.startTime = startTime;
    }

    public boolean plus(int amount) {
        this.progress += Math.max(0, amount);
        return this.progress >= this.quest.getTargetAmount();
    }

    public boolean plus() {
        return this.plus(1);
    }

    public boolean minus(int amount) {
        this.progress -= Math.max(0, amount);
        return this.progress >= this.quest.getTargetAmount();
    }

    public boolean minus() {
        return this.minus(1);
    }

    public void startTicking(final Runnable callbackOnTimeLimit) {
        if (this.tickingTask != null) {
            return;
        }
        this.tickingTask = new BukkitRunnable(){

            public void run() {
                long elapsed = QuestProgress.this.getElapsed();
                if (elapsed > QuestProgress.this.quest.getTimeLimit()) {
                    this.cancel();
                    callbackOnTimeLimit.run();
                    QuestProgress.this.tickingTask = null;
                }
            }
        };
        this.tickingTask.runTaskTimer((Plugin)FarmQuest.getInstance(), 0L, 20L);
    }

    public void stopTicking() {
        if (this.tickingTask == null) {
            return;
        }
        this.tickingTask.cancel();
        this.tickingTask = null;
    }

    public long getElapsed() {
        return Instant.now().getEpochSecond() - this.startTime;
    }

    public boolean isTicking() {
        return this.tickingTask != null;
    }

    @Generated
    public Quest getQuest() {
        return this.quest;
    }

    @Generated
    public Farm getFarm() {
        return this.farm;
    }

    @Generated
    public int getProgress() {
        return this.progress;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public BukkitRunnable getTickingTask() {
        return this.tickingTask;
    }
}

