/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.quest;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.model.farm.Farm;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.QuestProgress;
import org.nandayo.farmquest.model.quest.Reward;

public class Quest
extends Objective {
    @NotNull
    private final String id;
    private final String name;
    private final String description;
    private static final Collection<Quest> registeredQuests = new ArrayList<Quest>();

    public Quest(@NotNull String id, @NotNull String name, @NotNull String description, @NotNull Objective.ObjectiveType type, @NotNull FarmBlock farmBlock, int targetAmount, long timeLimit, @NotNull Collection<Reward> rewards) {
        super(type, farmBlock, targetAmount, timeLimit, rewards);
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public Quest(@NotNull String name, @NotNull String description, @NotNull Objective.ObjectiveType type, @NotNull FarmBlock farmBlock, int targetAmount, long timeLimit, @NotNull Collection<Reward> rewards) {
        this(Util.generateRandomLowerCaseString(2), name, description, type, farmBlock, targetAmount, timeLimit, rewards);
    }

    public void register() {
        if (Quest.getQuest(this.id) == null) {
            registeredQuests.add(this);
        } else {
            Util.log(String.format("{WARN}Quest with id '%s' was already registered.", this.id));
        }
    }

    @Nullable
    public QuestProgress freshProgress(@NotNull Farm farm) {
        if (!farm.getQuests().contains(this)) {
            return null;
        }
        return new QuestProgress(this, farm, 0, Instant.now().getEpochSecond());
    }

    @Nullable
    public static Quest getQuest(@NotNull String id) {
        return registeredQuests.stream().filter(q -> q.getId().equals(id)).findFirst().orElse(null);
    }

    public static Quest getQuestOrThrow(@NotNull String id) {
        Quest quest = Quest.getQuest(id);
        if (quest != null) {
            return quest;
        }
        throw new NullPointerException("Quest is null.");
    }

    @NotNull
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public static Collection<Quest> getRegisteredQuests() {
        return registeredQuests;
    }
}

