/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.quest;

import java.util.Collection;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.farmquest.enumeration.FarmBlock;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.model.quest.Reward;

public class Objective {
    private final ObjectiveType type;
    private final FarmBlock farmBlock;
    private final int targetAmount;
    private final long timeLimit;
    private final Collection<Reward> rewards;

    public Objective(@NotNull ObjectiveType type, @NotNull FarmBlock farmBlock, int targetAmount, long timeLimit, @NotNull Collection<Reward> rewards) {
        this.type = type;
        this.farmBlock = farmBlock;
        this.targetAmount = targetAmount;
        this.timeLimit = timeLimit;
        this.rewards = rewards;
    }

    public void grantRewards(@NotNull Farmer farmer) {
        for (Reward reward : this.rewards) {
            reward.grant(farmer);
        }
    }

    @Generated
    public ObjectiveType getType() {
        return this.type;
    }

    @Generated
    public FarmBlock getFarmBlock() {
        return this.farmBlock;
    }

    @Generated
    public int getTargetAmount() {
        return this.targetAmount;
    }

    @Generated
    public long getTimeLimit() {
        return this.timeLimit;
    }

    @Generated
    public Collection<Reward> getRewards() {
        return this.rewards;
    }

    public static enum ObjectiveType {
        HARVEST("Harvest"),
        PLANT("Plant"),
        DELIVER("Deliver");

        private final String displayName;

        private ObjectiveType(String displayName) {
            this.displayName = displayName;
        }

        @Nullable
        public static ObjectiveType get(@NotNull String name) {
            try {
                return ObjectiveType.valueOf(name.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }
    }
}

