/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.model.farm;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.Util;
import org.nandayo.farmquest.FarmQuest;

public class FarmTool {
    private final String id;
    private final String name;
    private final ItemStack item;
    private static final Collection<FarmTool> registeredTools = new ArrayList<FarmTool>();

    public FarmTool(@NotNull String id, @NotNull String name, @NotNull ItemStack item) {
        this.id = id;
        this.name = name;
        this.item = item;
    }

    public void register() {
        if (FarmTool.getTool(this.id) == null) {
            registeredTools.add(this);
        } else {
            Util.log(String.format("{WARN}FarmTool with id '%s' was already registered.", this.id));
        }
    }

    public Collection<ItemStack> getExtraDrops(@NotNull Collection<ItemStack> actualDrops) {
        float chance;
        if (actualDrops.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.id.equals("rookie_hoe") && (chance = FarmQuest.getInstance().random.nextFloat()) < 0.1f) {
            for (ItemStack drop : actualDrops) {
                ItemStack d = drop.clone();
                d.setAmount(1);
                drops.add(d);
            }
        }
        return drops;
    }

    @Nullable
    public static FarmTool getTool(@NotNull String id) {
        return registeredTools.stream().filter(t -> t.getId().equals(id)).findFirst().orElse(null);
    }

    @Nullable
    public static FarmTool getTool(@NotNull ItemStack item) {
        return registeredTools.stream().filter(t -> t.getItem().isSimilar(item)).findFirst().orElse(null);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ItemStack getItem() {
        return this.item;
    }

    @Generated
    public static Collection<FarmTool> getRegisteredTools() {
        return registeredTools;
    }
}

