/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.model.quest.Quest;

public class QuestListMenu
extends Menu {
    private final FarmQuest plugin;

    public QuestListMenu(@NotNull FarmQuest plugin) {
        this.plugin = plugin;
    }

    public void open(@NotNull Player player, final @NotNull Consumer<Quest> consumer) {
        this.createInventory(54, this.plugin.languageUtil.getString("menu.quest_list.title"));
        int slot = 0;
        for (final Quest quest : Quest.getRegisteredQuests()) {
            this.addButton(new Button(slot++){

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.PAPER).name(QuestListMenu.this.plugin.languageUtil.getString("menu.quest_list.quest.name").replace("{quest}", quest.getId())).lore(() -> {
                        List<String> rawLore = QuestListMenu.this.plugin.languageUtil.getStringList("menu.quest_list.quest.lore");
                        ArrayList<String> lore = new ArrayList<String>();
                        Iterator<String> iterator = rawLore.iterator();
                        while (iterator.hasNext()) {
                            String line;
                            String fixedLine = line = iterator.next();
                            if (line.contains("{quest}")) {
                                fixedLine = line.replace("{quest}", quest.getId());
                            }
                            if (line.contains("{quest_name}")) {
                                fixedLine = line.replace("{quest_name}", quest.getName());
                            }
                            if (line.contains("{quest_description}")) {
                                fixedLine = line.replace("{quest_description}", quest.getDescription());
                            }
                            lore.add(fixedLine);
                        }
                        return lore;
                    }).get();
                }

                @Override
                public void onClick(Player player, ClickType clickType) {
                    consumer.accept(quest);
                }
            });
        }
        this.displayTo(player);
    }
}

