/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.menu.QuestListMenu;
import org.nandayo.farmquest.model.farm.Farm;
import org.nandayo.farmquest.model.quest.Quest;

public class FarmEditorMenu
extends Menu {
    private final FarmQuest plugin;

    public FarmEditorMenu(@NotNull FarmQuest plugin) {
        this.plugin = plugin;
    }

    public void open(@NotNull Player viewer, final @NotNull Farm farm) {
        this.createInventory(9, this.plugin.languageUtil.getString("menu.farm_editor.title").replace("{farm}", farm.getId()));
        this.addButton(new Button(0){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.HAY_BLOCK).name(FarmEditorMenu.this.plugin.languageUtil.getString("menu.farm_editor.region.name").replace("{region}", farm.getRegion().parseString())).lore(FarmEditorMenu.this.plugin.languageUtil.getStringList("menu.farm_editor.region.lore").stream().map(l -> l.replace("{region}", farm.getRegion().parseString())).toList()).get();
            }

            @Override
            public void onClick(Player player, ClickType clickType) {
            }
        });
        this.addButton(new Button(1){
            final List<Quest> linkedQuests;
            {
                super(slot);
                this.linkedQuests = farm.getQuests().stream().filter(Objects::nonNull).toList();
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.WRITABLE_BOOK).name(FarmEditorMenu.this.plugin.languageUtil.getString("menu.farm_editor.linked_quests.name")).lore("").addLore(() -> {
                    List<String> rawLore = FarmEditorMenu.this.plugin.languageUtil.getStringList("menu.farm_editor.linked_quests.lore");
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : rawLore) {
                        if (line.contains("{quest.%n}")) {
                            for (Quest quest : this.linkedQuests) {
                                lore.add(line.replace("{quest.%n}", quest.getId()));
                            }
                            continue;
                        }
                        lore.add(line);
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(Player player, ClickType clickType) {
                if (clickType == ClickType.LEFT) {
                    new QuestListMenu(FarmEditorMenu.this.plugin).open(player, quest -> {
                        if (farm.linkQuest((Quest)quest)) {
                            FarmEditorMenu.this.plugin.farmRegistry.save();
                            FarmEditorMenu.this.plugin.tell((CommandSender)player, FarmEditorMenu.this.plugin.languageUtil.getString("quest_linked_to_farm").replace("{farm}", farm.getId()));
                            player.playSound(player.getLocation(), Sound.BLOCK_CHAIN_PLACE, 1.0f, 1.0f);
                        } else {
                            FarmEditorMenu.this.plugin.tell((CommandSender)player, FarmEditorMenu.this.plugin.languageUtil.getString("quest_already_linked_to_farm").replace("{farm}", farm.getId()));
                        }
                        new FarmEditorMenu(FarmEditorMenu.this.plugin).open(player, farm);
                    });
                } else if (clickType == ClickType.RIGHT) {
                    new QuestListMenu(FarmEditorMenu.this.plugin).open(player, quest -> {
                        if (farm.unlinkQuest((Quest)quest)) {
                            FarmEditorMenu.this.plugin.farmRegistry.save();
                            FarmEditorMenu.this.plugin.tell((CommandSender)player, FarmEditorMenu.this.plugin.languageUtil.getString("quest_unlink_from_farm").replace("{farm}", farm.getId()));
                            player.playSound(player.getLocation(), Sound.BLOCK_CHAIN_BREAK, 1.0f, 1.0f);
                        } else {
                            FarmEditorMenu.this.plugin.tell((CommandSender)player, FarmEditorMenu.this.plugin.languageUtil.getString("quest_already_not_linked_to_farm").replace("{farm}", farm.getId()));
                        }
                        new FarmEditorMenu(FarmEditorMenu.this.plugin).open(player, farm);
                    });
                }
            }
        });
        this.displayTo(viewer);
    }
}

