/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.listener;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.nandayo.farmquest.FarmQuest;
import org.nandayo.farmquest.event.QuestCompleteEvent;
import org.nandayo.farmquest.event.QuestProgressEvent;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.model.quest.Objective;
import org.nandayo.farmquest.model.quest.QuestProgress;
import org.nandayo.farmquest.util.MaterialUtil;

public class CustomListener
implements Listener {
    @EventHandler
    public void onQuestProgress(QuestProgressEvent event) {
        Farmer farmer = event.getFarmer();
        QuestProgress questProgress = event.getQuestProgress();
        if (questProgress.plus(event.getProgress())) {
            Bukkit.getScheduler().runTask((Plugin)FarmQuest.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)new QuestCompleteEvent(farmer, event.getQuestProgress())));
        }
    }

    @EventHandler
    public void onQuestComplete(QuestCompleteEvent event) {
        Farmer farmer = event.getFarmer();
        farmer.dropQuest(true);
        QuestProgress questProgress = event.getQuestProgress();
        Player player = farmer.getOfflinePlayer().getPlayer();
        if (questProgress.getQuest().getType() == Objective.ObjectiveType.DELIVER && player != null) {
            MaterialUtil.removeMaterials(player, questProgress.getQuest().getFarmBlock().getCropMaterial(), questProgress.getQuest().getTargetAmount());
        }
        questProgress.getQuest().grantRewards(farmer);
        farmer.tell(FarmQuest.getInstance().languageUtil.getString("quest_complete").replace("{quest}", questProgress.getQuest().getName()));
    }
}

