/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.enumeration;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum VerticalGrowthType {
    UP(new Material[]{Material.BAMBOO, Material.KELP, Material.KELP_PLANT, Material.CACTUS, Material.SUGAR_CANE}),
    DOWN(new Material[]{Material.CAVE_VINES, Material.CAVE_VINES_PLANT});

    private final Material[] materials;
    private static final Map<Material, VerticalGrowthType> GROWTH_TYPE_MAP;

    private VerticalGrowthType(Material[] materials) {
        this.materials = materials;
    }

    public BlockFace getBlockFace() {
        return BlockFace.valueOf((String)this.toString());
    }

    @Nullable
    public static VerticalGrowthType get(@NotNull Material material) {
        return GROWTH_TYPE_MAP.get(material);
    }

    @Generated
    public Material[] getMaterials() {
        return this.materials;
    }

    static {
        GROWTH_TYPE_MAP = new HashMap<Material, VerticalGrowthType>();
        for (Material material : VerticalGrowthType.UP.materials) {
            GROWTH_TYPE_MAP.put(material, UP);
        }
        for (Material material : VerticalGrowthType.DOWN.materials) {
            GROWTH_TYPE_MAP.put(material, DOWN);
        }
    }
}

