/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest.enumeration;

import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.object.DMaterial;

public enum FarmBlock {
    WHEAT(Material.WHEAT_SEEDS, Material.WHEAT, Material.WHEAT),
    CARROTS(Material.CARROT, Material.CARROT, Material.CARROTS),
    POTATOES(Material.POTATO, Material.POTATO, Material.POTATOES),
    CAVE_VINES(Material.GLOW_BERRIES, Material.GLOW_BERRIES, Material.CAVE_VINES, Material.CAVE_VINES_PLANT),
    NETHER_WART(Material.NETHER_WART, Material.NETHER_WART, Material.NETHER_WART),
    KELP(Material.KELP, Material.KELP, Material.KELP, Material.KELP_PLANT),
    CACTUS(Material.CACTUS, Material.CACTUS, Material.CACTUS),
    SWEET_BERRY_BUSH(Material.SWEET_BERRIES, Material.SWEET_BERRIES, Material.SWEET_BERRY_BUSH),
    SUGAR_CANE(Material.SUGAR_CANE, Material.SUGAR_CANE, Material.SUGAR_CANE),
    COCOA(Material.COCOA_BEANS, Material.COCOA_BEANS, Material.COCOA),
    PITCHER_CROP(DMaterial.PITCHER_POD, DMaterial.PITCHER_PLANT, DMaterial.PITCHER_CROP),
    BAMBOO(Material.BAMBOO, Material.BAMBOO, Material.BAMBOO, Material.BAMBOO_SAPLING),
    MELON(Material.MELON_SEEDS, Material.MELON_SLICE, Material.MELON),
    BEETROOTS(Material.BEETROOT_SEEDS, Material.BEETROOT, Material.BEETROOTS),
    PUMPKIN(Material.PUMPKIN_SEEDS, Material.PUMPKIN, Material.PUMPKIN),
    TORCHFLOWER_SEEDS(DMaterial.TORCHFLOWER_SEEDS, DMaterial.TORCHFLOWER, DMaterial.TORCHFLOWER);

    @NotNull
    private final Material seedMaterial;
    @NotNull
    private final Material cropMaterial;
    @NotNull
    private final Collection<Material> blockMaterials;

    private FarmBlock(Material seedMaterial, Material cropMaterial, Material ... blockMaterials) {
        this.seedMaterial = seedMaterial;
        this.cropMaterial = cropMaterial;
        this.blockMaterials = Arrays.asList(blockMaterials);
    }

    private FarmBlock(DMaterial seedMaterial, DMaterial cropMaterial, DMaterial ... blockMaterials) {
        this.seedMaterial = seedMaterial.parseMaterial() == null ? Material.AIR : seedMaterial.parseMaterial();
        this.cropMaterial = cropMaterial.parseMaterial() == null ? Material.AIR : cropMaterial.parseMaterial();
        this.blockMaterials = Arrays.stream(blockMaterials).map(m -> m.parseMaterial() == null ? Material.AIR : m.parseMaterial()).toList();
    }

    public boolean equals(@NotNull FarmBlock other) {
        return this.toString().equals(other.toString());
    }

    public boolean equals(@NotNull Material material) {
        FarmBlock other = FarmBlock.get(material);
        return other != null && this.equals(other);
    }

    @Nullable
    public static FarmBlock get(@NotNull Material material) {
        for (FarmBlock block : FarmBlock.values()) {
            if (block.getSeedMaterial() != material && block.getCropMaterial() != material && !block.getBlockMaterials().contains(material)) continue;
            return block;
        }
        return null;
    }

    @Nullable
    public static FarmBlock get(@NotNull String material) {
        Material mat = Material.getMaterial((String)material);
        if (mat == null) {
            return null;
        }
        return FarmBlock.get(mat);
    }

    public static boolean isFarmBlock(@NotNull Material material) {
        return FarmBlock.get(material) != null;
    }

    @NotNull
    @Generated
    public Material getSeedMaterial() {
        return this.seedMaterial;
    }

    @NotNull
    @Generated
    public Material getCropMaterial() {
        return this.cropMaterial;
    }

    @NotNull
    @Generated
    public Collection<Material> getBlockMaterials() {
        return this.blockMaterials;
    }
}

